/*
 * Decompiled with CFR 0.152.
 */
package placement;

import java.awt.Color;
import java.util.StringTokenizer;
import java.util.Vector;
import placement.PLayout;
import placement.PTerminal;
import placement.moves.PMove;

public class PModule {
    private int x;
    private int y;
    private int w;
    private int h;
    private String name;
    private static PLayout layout;
    private Vector lnkTerminals = new Vector();

    public static void setLayout(PLayout pLayout) {
        layout = pLayout;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMoveModule() {
        PMove pMove = layout.getLastMove();
        if (pMove == null) {
            return false;
        }
        return pMove.getMoveModule() == this;
    }

    public Color getColor() {
        if (this.isMoveModule()) {
            PMove pMove = layout.getLastMove();
            return pMove.getMoveStatus().getColor();
        }
        return Color.yellow;
    }

    public PTerminal getTerminal(int n) {
        return (PTerminal)this.lnkTerminals.elementAt(n);
    }

    public int numTerminals() {
        return this.lnkTerminals.size();
    }

    public void addTerminal(PTerminal pTerminal) {
        if (!this.lnkTerminals.contains(pTerminal)) {
            this.lnkTerminals.addElement(pTerminal);
        }
    }

    public PTerminal findTerminal(String string) {
        int n = 0;
        while (n < this.lnkTerminals.size()) {
            PTerminal pTerminal = (PTerminal)this.lnkTerminals.elementAt(n);
            if (string.equals(pTerminal.getName())) {
                return pTerminal;
            }
            ++n;
        }
        return null;
    }

    public PModule(String string, int n, int n2, int n3, int n4) {
        this.name = string;
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
        layout.calcCost();
    }

    public int area() {
        return this.w * this.h;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCenterX() {
        return this.getX() + this.width() / 2;
    }

    public int getCenterY() {
        return this.getY() + this.height() / 2;
    }

    public int leftEdge() {
        return this.x;
    }

    public int rightEdge() {
        return this.x + this.w;
    }

    public int topEdge() {
        return this.y;
    }

    public int bottomEdge() {
        return this.y + this.h;
    }

    public int width() {
        return this.w;
    }

    public int height() {
        return this.h;
    }

    public boolean overlaps(PModule pModule) {
        if (pModule.leftEdge() > this.rightEdge()) {
            return false;
        }
        if (pModule.rightEdge() < this.leftEdge()) {
            return false;
        }
        if (pModule.bottomEdge() < this.topEdge()) {
            return false;
        }
        return pModule.topEdge() <= this.bottomEdge();
    }

    public int overlapArea(PModule pModule) {
        if (!this.overlaps(pModule)) {
            return 0;
        }
        int n = Math.max(pModule.leftEdge(), this.leftEdge());
        int n2 = Math.min(pModule.rightEdge(), this.rightEdge());
        int n3 = Math.max(pModule.topEdge(), this.topEdge());
        int n4 = Math.min(pModule.bottomEdge(), this.bottomEdge());
        return (n4 - n3) * (n2 - n);
    }

    public double move(int n, int n2) {
        this.x += n;
        this.y += n2;
        layout.calcCost();
        return layout.getDeltaCost();
    }

    public double rotate() {
        int n = this.w;
        this.w = this.h;
        this.h = n;
        int n2 = 0;
        while (n2 < this.lnkTerminals.size()) {
            PTerminal pTerminal = (PTerminal)this.lnkTerminals.elementAt(n2);
            pTerminal.rotate();
            ++n2;
        }
        layout.calcCost();
        return layout.getDeltaCost();
    }

    public double flipVertical() {
        int n = 0;
        while (n < this.lnkTerminals.size()) {
            PTerminal pTerminal = (PTerminal)this.lnkTerminals.elementAt(n);
            pTerminal.flipVertical();
            ++n;
        }
        layout.calcCost();
        return layout.getDeltaCost();
    }

    public double flipHorizontal() {
        int n = 0;
        while (n < this.lnkTerminals.size()) {
            PTerminal pTerminal = (PTerminal)this.lnkTerminals.elementAt(n);
            pTerminal.flipHorizontal();
            ++n;
        }
        layout.calcCost();
        return layout.getDeltaCost();
    }

    public String toString() {
        return "PModule " + this.name + "(" + this.x + "," + this.y + "," + this.w + "," + this.h + ") area=" + this.area();
    }

    public static PModule parseModule(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        return new PModule(string, n, n2, n3, n4);
    }

    public static void main(String[] stringArray) {
        PModule pModule = new PModule("r1", 3, 3, 4, 4);
        PModule pModule2 = new PModule("r2", 2, 5, 3, 3);
        PModule pModule3 = new PModule("r3", 8, 2, 2, 5);
        System.out.println("c1: " + pModule);
        System.out.println("c2: " + pModule2);
        System.out.println("c3: " + pModule3);
        System.out.println("c1.overlaps(c2) => " + pModule.overlaps(pModule2));
        System.out.println("c1.overlaps(c3) => " + pModule.overlaps(pModule3));
        System.out.println("c2.overlaps(c2) => " + pModule2.overlaps(pModule3));
        System.out.println("c1.overlapArea(c2) => " + pModule.overlapArea(pModule2));
        System.out.println("c1.overlapArea(c3) => " + pModule.overlapArea(pModule3));
        System.out.println("c2.overlapArea(c3) => " + pModule2.overlapArea(pModule3));
    }
}

