/*
 * Decompiled with CFR 0.152.
 */
package placement.anneal;

import java.util.ArrayList;
import java.util.List;
import placement.anneal.PTempHistoryPoint;

public class PTempHistory {
    private double maxTemperature = 0.0;
    public double maxAcceptedCost = 0.0;
    private double maxAverageCost = 0.0;
    private double overallMinCost = Double.MAX_VALUE;
    private List historyList = new ArrayList();
    private PTempHistoryPoint currentTempPoint = null;

    public double getOverallMaxTemperature() {
        return this.maxTemperature;
    }

    public double getMaxAcceptedCost() {
        return this.maxAcceptedCost;
    }

    public double getMaxAverageCost() {
        return this.maxAverageCost;
    }

    public double getOverallMinCost() {
        return this.overallMinCost;
    }

    public void addTempPoint(double d, double d2) {
        if (this.currentTempPoint != null) {
            this.maxAverageCost = Math.max(this.maxAverageCost, this.currentTempPoint.getAverageCost());
        }
        this.currentTempPoint = new PTempHistoryPoint(d, d2);
        this.historyList.add(this.currentTempPoint);
        this.maxTemperature = Math.max(this.maxTemperature, d);
    }

    public PTempHistoryPoint getTempPoint(int n) {
        return (PTempHistoryPoint)this.historyList.get(n);
    }

    public PTempHistoryPoint getCurrentTempPoint() {
        return this.currentTempPoint;
    }

    public void completeCurrentTempPoint() {
        this.currentTempPoint.complete();
        this.maxAcceptedCost = Math.max(this.maxAcceptedCost, this.currentTempPoint.getMaxCost());
        this.overallMinCost = Math.min(this.overallMinCost, this.currentTempPoint.getMinCost());
    }

    public int numTempPoints() {
        return this.historyList.size();
    }

    public void reset() {
        this.historyList.clear();
        this.maxTemperature = 0.0;
        this.maxAcceptedCost = 0.0;
        this.maxAverageCost = 0.0;
        this.overallMinCost = Double.MAX_VALUE;
    }

    public double getCurrentTemp() {
        return this.currentTempPoint.getTemperature();
    }
}

