/*
 * Decompiled with CFR 0.152.
 */
package placement.moves;

import java.util.ArrayList;
import java.util.List;
import placement.moves.PMoveHistoryPoint;

public class PMoveHistory {
    private List points = new ArrayList(500);
    private double maxCost = 0.0;
    private double minCost = 0.0;
    private double initCost = 0.0;
    private double lastCost = 0.0;
    private int acceptCount = 0;
    private double sumAcceptedCost = 0.0;

    public void reset(double d) {
        this.points.clear();
        this.initCost = this.lastCost = d;
        this.minCost = this.lastCost;
        this.maxCost = this.lastCost;
        this.acceptCount = 0;
        this.sumAcceptedCost = 0.0;
    }

    public void add(PMoveHistoryPoint pMoveHistoryPoint) {
        this.points.add(pMoveHistoryPoint);
        if (pMoveHistoryPoint.accepted()) {
            ++this.acceptCount;
            this.lastCost += pMoveHistoryPoint.getDeltaCost();
            this.sumAcceptedCost += this.lastCost;
            if (this.lastCost > this.maxCost) {
                this.maxCost = this.lastCost;
            }
            if (this.lastCost < this.minCost) {
                this.minCost = this.lastCost;
            }
        }
    }

    public PMoveHistoryPoint get(int n) {
        return (PMoveHistoryPoint)this.points.get(n);
    }

    public PMoveHistoryPoint getCurrent() {
        return (PMoveHistoryPoint)this.points.get(this.points.size() - 1);
    }

    public int size() {
        return this.points.size();
    }

    public int getAttemptCount() {
        return this.points.size();
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public int getRejectCount() {
        return this.getAttemptCount() - this.acceptCount;
    }

    public double getAcceptPercent() {
        if (this.getAttemptCount() == 0) {
            return 0.0;
        }
        return (double)this.getAcceptCount() / (double)this.getAttemptCount() * 100.0;
    }

    public void setInitCost(double d) {
        this.initCost = d;
        this.minCost = d;
        this.maxCost = d;
        this.lastCost = d;
    }

    public double getInitCost() {
        return this.initCost;
    }

    public double getMinCost() {
        return this.minCost;
    }

    public double getMaxCost() {
        return this.maxCost;
    }

    public double getAverageCost() {
        return this.sumAcceptedCost / (double)this.acceptCount;
    }

    public double getStdev() {
        double d = 0.0;
        double d2 = this.initCost;
        double d3 = this.getAverageCost();
        int n = 0;
        while (n < this.points.size()) {
            double d4 = (d2 += ((PMoveHistoryPoint)this.points.get(n)).getDeltaCost()) - d3;
            d += d4 * d4;
            ++n;
        }
        return Math.sqrt(d / (double)(this.acceptCount - 1));
    }
}

