/*
 * Decompiled with CFR 0.152.
 */
package placement.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import placement.ui.UIModule;

public class DragListener
implements MouseListener,
MouseMotionListener {
    private int firstX = 0;
    private int firstY = 0;

    public void mouseClicked(MouseEvent mouseEvent) {
        UIModule uIModule = (UIModule)mouseEvent.getComponent();
        if (mouseEvent.isAltDown()) {
            uIModule.flipVertical();
        } else if (mouseEvent.isShiftDown()) {
            uIModule.flipHorizontal();
        } else {
            uIModule.rotate();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.firstX = mouseEvent.getX();
        this.firstY = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.firstX = 0;
        this.firstY = 0;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.firstX;
        int n2 = mouseEvent.getY() - this.firstY;
        Component component = mouseEvent.getComponent();
        Point point = component.getLocation();
        point.x += n;
        point.y += n2;
        component.setLocation(point);
        component.getParent().getParent().repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

