/*
 * Decompiled with CFR 0.152.
 */
package placement.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import placement.PLayout;
import placement.PModule;
import placement.anneal.PAnnealInterface;
import placement.moves.PMove;
import placement.ui.UIModule;
import placement.ui.UIPlacementPanel;
import placement.ui.UIValDisplay;

public class UILayout
extends JPanel
implements ActionListener,
PAnnealInterface {
    JPanel messagePanel;
    private List moduleList = new ArrayList();
    private static int offsetX = 0;
    private static int offsetY = 0;
    private static double zoom = 2.0;
    private PLayout myLayout;
    private UIPlacementPanel placementPanel;
    private JPanel statusPanel;
    private UIValDisplay areaDisplay;
    private UIValDisplay olapDisplay;
    private UIValDisplay wireDisplay;
    private UIValDisplay costDisplay;
    private JLabel messageLabel;
    private JButton fitButton;
    private boolean updateAllModules = false;

    public UILayout(PLayout pLayout) {
        this.myLayout = pLayout;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.placementPanel = new UIPlacementPanel(this.myLayout);
        this.add((Component)this.placementPanel, "Center");
        this.placementPanel.setVisible(true);
        this.placementPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)this.placementPanel, "Center");
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new GridLayout(1, 4));
        this.areaDisplay = new UIValDisplay("Area", 0);
        this.statusPanel.add(this.areaDisplay);
        this.olapDisplay = new UIValDisplay("Overlap", 0);
        this.statusPanel.add(this.olapDisplay);
        this.wireDisplay = new UIValDisplay("Wirelength", 0);
        this.statusPanel.add(this.wireDisplay);
        this.costDisplay = new UIValDisplay("Cost", 0);
        this.statusPanel.add(this.costDisplay);
        this.add((Component)this.statusPanel, "North");
        this.messagePanel = new JPanel();
        this.messagePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.messagePanel.setLayout(new FlowLayout(0));
        this.fitButton = new JButton("FIT");
        this.fitButton.addActionListener(this);
        this.messagePanel.add(this.fitButton);
        this.messageLabel = new JLabel("This Space for Rent");
        this.messagePanel.add(this.messageLabel);
        this.messagePanel.add(Box.createHorizontalGlue());
        this.add((Component)this.messagePanel, "South");
        this.addModules();
        this.myLayout.calcCost();
    }

    private void addModules() {
        int n = 0;
        while (n < this.myLayout.numModules()) {
            PModule pModule = this.myLayout.getModule(n);
            UIModule uIModule = new UIModule(pModule);
            this.moduleList.add(uIModule);
            this.placementPanel.getContentPane().add(uIModule);
            ++n;
        }
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string);
    }

    public void setMoveMessage() {
        PMove pMove = this.myLayout.getLastMove();
        if (pMove != null) {
            this.setMessage(pMove.toString());
        } else {
            this.setMessage("");
        }
    }

    public void setCostDisplay() {
        this.areaDisplay.setValue(this.myLayout.currentArea());
        this.olapDisplay.setValue(this.myLayout.currentOverlap());
        this.wireDisplay.setValue(this.myLayout.currentWirelength());
        this.costDisplay.setValue(this.myLayout.currentCost());
        this.statusPanel.repaint();
    }

    public void paintComponent(Graphics graphics) {
        UIModule uIModule;
        int n;
        if (this.updateAllModules) {
            n = 0;
            while (n < this.moduleList.size()) {
                uIModule = (UIModule)this.moduleList.get(n);
                uIModule.updateLocation();
                this.updateAllModules = false;
                ++n;
            }
        }
        if ((n = this.myLayout.getMoveModuleNumber()) >= 0) {
            uIModule = (UIModule)this.moduleList.get(n);
            uIModule.updateLocation();
            int n2 = uIModule.getX();
            int n3 = uIModule.getY();
            if (n2 + uIModule.getWidth() < 0 || n3 + uIModule.getHeight() < 0 || n2 > this.placementPanel.getWidth() || n3 > this.placementPanel.getHeight()) {
                this.autoZoom(1.2);
            }
        }
        this.setCostDisplay();
        this.setMoveMessage();
        super.paintComponent(graphics);
    }

    public static int scale(int n) {
        return (int)((double)n * zoom);
    }

    public static int translateX(int n) {
        return (int)((double)(offsetX + n) * zoom);
    }

    public static int translateY(int n) {
        return (int)((double)(offsetY + n) * zoom);
    }

    public static int untranslateX(int n) {
        return (int)((double)n / zoom - (double)offsetX);
    }

    public static int untranslateY(int n) {
        return (int)((double)n / zoom - (double)offsetY);
    }

    public static int unscale(int n) {
        return (int)((double)n / zoom);
    }

    public static void setZoom(double d) {
        zoom = d;
    }

    public void autoZoom() {
        this.autoZoom(1.1);
    }

    public void autoZoom(double d) {
        if (d < 1.0) {
            d = 1.0;
        }
        double d2 = (d - 1.0) / 2.0;
        offsetX = -(this.myLayout.currentLeftEdge() - (int)((double)this.myLayout.currentWidth() * d2));
        offsetY = -(this.myLayout.currentTopEdge() - (int)((double)this.myLayout.currentHeight() * d2));
        double d3 = (double)this.placementPanel.getWidth() / ((double)this.myLayout.currentWidth() * d);
        double d4 = (double)this.placementPanel.getHeight() / ((double)this.myLayout.currentHeight() * d);
        zoom = Math.min(d3, d4);
        this.updateAllModules = true;
        this.repaint();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "FIT") {
            this.autoZoom(1.2);
        }
    }

    public void showSelectMove() throws InterruptedException {
        this.repaint();
    }

    public void showAcceptMove() throws InterruptedException {
        this.repaint();
    }

    public void showRejectMove() throws InterruptedException {
        this.repaint();
    }

    public void showCompleteMove() throws InterruptedException {
        this.repaint();
    }

    public void showUpdateTemperature() throws InterruptedException {
        this.autoZoom(1.2);
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PLayout pLayout = new PLayout("ntest10.in");
        JFrame jFrame = new JFrame("UILayout Test");
        UILayout uILayout = new UILayout(pLayout);
        uILayout.setSize(200, 200);
        ((Component)jFrame).setSize(300, 300);
        jFrame.getContentPane().add(uILayout);
        ((Component)jFrame).setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        uILayout.autoZoom(3.0);
    }
}

