/*
 * Decompiled with CFR 0.152.
 */
package placement.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UIMetropolisGauge
extends JPanel {
    private double r;
    private double p;
    private static final int GAUGE_WIDTH = 60;
    private static final int GAUGE_HEIGHT = 14;
    private static final int BASELINE_HEIGHT = 3;
    private static final int R_SIZE = 8;
    private static Color pBarAcceptColor = Color.green;
    private static Color pBarRejectColor = Color.red;
    private static Color trAcceptColor = Color.white;
    private static Color trRejectColor = Color.black;
    private int[] diamondX = new int[4];
    private int[] diamondY = new int[4];
    private int[] triangleX = new int[3];
    private int[] triangleY = new int[3];
    private static NumberFormat nf = NumberFormat.getInstance();

    public void setValues(double d, double d2) {
        if (this.r != d && this.p != d2) {
            if (d < 0.0 || d2 < 0.0) {
                this.setToolTipText("");
            } else {
                this.setToolTipText("P=" + nf.format(d2) + " r=" + nf.format(d));
            }
            this.r = d;
            this.p = d2;
            this.repaint();
        }
    }

    public UIMetropolisGauge(double d, double d2) {
        this.r = d;
        this.p = d2;
    }

    public UIMetropolisGauge() {
        this(0.0, 0.0);
    }

    public Dimension getMinimumSize() {
        return new Dimension(70, 24);
    }

    public Dimension getPreferredSize() {
        return new Dimension(70, 24);
    }

    private void drawTriangle(Graphics graphics, boolean bl, int n, int n2) {
        this.triangleX[0] = n - 5;
        this.triangleX[1] = n + 4 + 1;
        this.triangleX[2] = n;
        this.triangleY[0] = n2 - 8;
        this.triangleY[1] = n2 - 8;
        this.triangleY[2] = n2;
        if (bl) {
            graphics.setColor(trAcceptColor);
        } else {
            graphics.setColor(trRejectColor);
        }
        graphics.fillPolygon(this.triangleX, this.triangleY, 3);
        graphics.setColor(Color.black);
        graphics.drawPolygon(this.triangleX, this.triangleY, 3);
    }

    private void drawDiamond(Graphics graphics, int n, int n2) {
        this.diamondX[0] = n - 4;
        this.diamondX[1] = n;
        this.diamondX[2] = n + 4;
        this.diamondX[3] = n;
        this.diamondY[0] = n2;
        this.diamondY[1] = n2 + 4;
        this.diamondY[2] = n2;
        this.diamondY[3] = n2 - 4;
        graphics.setColor(Color.blue);
        graphics.fillPolygon(this.diamondX, this.diamondY, 4);
    }

    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = this.getWidth();
        int n2 = this.getWidth() / 2 - 30;
        int n3 = this.getHeight() / 2 - 7;
        int n4 = n3 + 14;
        boolean bl = this.r < this.p;
        graphics.setColor(Color.black);
        graphics.fillRect(n2, n3 + 7 - 1, 60, 3);
        if (this.r < 0.0 || this.p < 0.0) {
            return;
        }
        if (this.p > 1.0) {
            this.p = 1.0;
        }
        int n5 = n3 + 7 + 1 + 1;
        if (bl) {
            graphics.setColor(pBarAcceptColor);
        } else {
            graphics.setColor(pBarRejectColor);
        }
        graphics.fillRect(n2, n5, (int)(60.0 * this.p), 6);
        if (this.p < 1.0 && this.r < 1.0) {
            this.drawTriangle(graphics, bl, n2 + (int)(60.0 * this.r), n3 + 7 - 1);
        }
    }

    public static void main(String[] stringArray) {
        UIMetropolisGauge uIMetropolisGauge = new UIMetropolisGauge(0.9, 0.6);
        UIMetropolisGauge uIMetropolisGauge2 = new UIMetropolisGauge(0.4, 0.75);
        UIMetropolisGauge uIMetropolisGauge3 = new UIMetropolisGauge(0.1, 0.05);
        UIMetropolisGauge uIMetropolisGauge4 = new UIMetropolisGauge(0.1, 0.2);
        UIMetropolisGauge uIMetropolisGauge5 = new UIMetropolisGauge(0.9, 0.95);
        UIMetropolisGauge uIMetropolisGauge6 = new UIMetropolisGauge(0.95, 0.9);
        UIMetropolisGauge uIMetropolisGauge7 = new UIMetropolisGauge(0.001, 5.0E-4);
        UIMetropolisGauge uIMetropolisGauge8 = new UIMetropolisGauge(0.001, 0.0015);
        UIMetropolisGauge uIMetropolisGauge9 = new UIMetropolisGauge(0.995, 0.996);
        UIMetropolisGauge uIMetropolisGauge10 = new UIMetropolisGauge(0.995, 0.994);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(uIMetropolisGauge2);
        jFrame.getContentPane().add(uIMetropolisGauge);
        jFrame.getContentPane().add(uIMetropolisGauge2);
        jFrame.getContentPane().add(uIMetropolisGauge3);
        jFrame.getContentPane().add(uIMetropolisGauge4);
        jFrame.getContentPane().add(uIMetropolisGauge5);
        jFrame.getContentPane().add(uIMetropolisGauge6);
        jFrame.getContentPane().add(uIMetropolisGauge7);
        jFrame.getContentPane().add(uIMetropolisGauge8);
        jFrame.getContentPane().add(uIMetropolisGauge9);
        jFrame.getContentPane().add(uIMetropolisGauge10);
        ((Component)jFrame).setVisible(true);
    }
}

