/*
 * Decompiled with CFR 0.152.
 */
package placement.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import placement.PModule;
import placement.PTerminal;
import placement.ui.DragListener;
import placement.ui.UILayout;

public class UIModule
extends JLabel {
    private static DragListener dragger = new DragListener();
    private PModule myModule;

    public UIModule(PModule pModule) {
        this.addMouseMotionListener(dragger);
        this.addMouseListener(dragger);
        this.myModule = pModule;
        this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.setText(pModule.getName());
        this.setBackground(Color.yellow);
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setSize(UILayout.scale(pModule.width()), UILayout.scale(pModule.height()));
        super.setLocation(UILayout.translateX(pModule.getX()), UILayout.translateY(pModule.getY()));
    }

    public void updateLocation() {
        this.setSize(UILayout.scale(this.myModule.width()), UILayout.scale(this.myModule.height()));
        super.setLocation(UILayout.translateX(this.myModule.getX()), UILayout.translateY(this.myModule.getY()));
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        this.myModule.setLocation(UILayout.untranslateX(n), UILayout.untranslateY(n2));
    }

    public void flipHorizontal() {
        this.myModule.flipHorizontal();
        this.getParent().getParent().repaint();
    }

    public void flipVertical() {
        this.myModule.flipVertical();
        this.getParent().getParent().repaint();
    }

    public void rotate() {
        this.myModule.rotate();
        this.getParent().getParent().repaint();
    }

    public void paintComponent(Graphics graphics) {
        this.updateLocation();
        this.setBackground(this.myModule.getColor());
        super.paintComponent(graphics);
        int n = 0;
        while (n < this.myModule.numTerminals()) {
            PTerminal pTerminal = this.myModule.getTerminal(n);
            graphics.setColor(Color.black);
            int n2 = Math.max(UILayout.scale(pTerminal.getX()) - 2, 0);
            int n3 = Math.max(UILayout.scale(pTerminal.getY()) - 2, 0);
            n2 = Math.min(n2, UILayout.scale(this.myModule.width()) - 5);
            n3 = Math.min(n3, UILayout.scale(this.myModule.height()) - 5);
            graphics.fillRect(n2, n3, 5, 5);
            ++n;
        }
    }
}

