/*
 * Decompiled with CFR 0.152.
 */
package placement.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;
import placement.moves.PMove;
import placement.moves.PMoveHistory;
import placement.moves.PMoveHistoryPoint;

public class UIMoveHistory
extends JPanel {
    private PMoveHistory myMoveHistory = PMove.getHistory();
    private static final int MOVE_DISPLAY_WIDTH = 8;
    private static final int LEFT_OFFSET = 25;
    private static final int RIGHT_OFFSET = 15;
    private static final int TOP_OFFSET = 25;
    private static final int BOT_OFFSET = 20;
    private static final double LOG10_SCALE = Math.log(10.0);
    private static final int METRO_DISPLAY_HEIGHT = 40;
    private static final int METRO_Y_MARGIN = 20;
    private static final Color brightOrange = new Color(255, 102, 51);
    private static final Color lightGreen = new Color(153, 255, 102);
    private int curWidth;
    private int curHeight;
    private int displayLeft;
    private int moveDisplayTop;
    private int moveDisplayBottom;
    private int moveDisplayHeight;
    private int metroDisplayTop;
    private int metroDisplayBottom;
    private double logCostTop;
    private double logCostBot;
    private double costScale;
    private double tempScale;
    private FontMetrics myFontMetrics;
    private boolean optMetropolisDisplay = false;
    private int[] drawTrapX = new int[4];
    private int[] drawTrapY = new int[4];
    private int[] fillTrapX = new int[4];
    private int[] fillTrapY = new int[4];
    private Insets insets;

    private static double log10(double d) {
        return Math.log(d) / LOG10_SCALE;
    }

    public void setOptMetropolisDisplay(boolean bl) {
        this.optMetropolisDisplay = bl;
    }

    private int log10CostToY(double d) {
        return this.moveDisplayBottom - (int)(this.costScale * (d - this.logCostBot));
    }

    private void drawXLabel(Graphics graphics, int n) {
        String string = Integer.toString(n);
        int n2 = this.displayLeft + n * 8 - this.myFontMetrics.stringWidth(string) / 2;
        int n3 = this.moveDisplayBottom + this.myFontMetrics.getHeight() - this.myFontMetrics.getDescent();
        graphics.drawString(string, n2, n3);
    }

    private void drawYCostLabel(Graphics graphics, int n) {
        String string = "1E" + Integer.toString(n);
        int n2 = this.displayLeft - this.myFontMetrics.stringWidth(string) - 2;
        int n3 = this.log10CostToY(n);
        graphics.drawString(string, n2, n3);
    }

    private void drawYMetroLabels(Graphics graphics) {
        int n = this.displayLeft - this.myFontMetrics.stringWidth("1") - 2;
        int n2 = this.metroDisplayTop + this.myFontMetrics.getHeight() / 2;
        graphics.drawString("1", n, n2);
        n2 = this.metroDisplayBottom + 2;
        graphics.drawString("0", n, n2);
    }

    public void setHistoryLength(int n) {
        Dimension dimension = this.getSize();
        dimension.width = 40 + n * 8;
        this.setPreferredSize(dimension);
    }

    public int moveLeft(int n) {
        return this.displayLeft + n * 8;
    }

    public int moveRight(int n) {
        return this.displayLeft + (n + 1) * 8;
    }

    public void paintComponent(Graphics graphics) {
        this.setBackground(Color.white);
        super.paintComponent(graphics);
        if (this.myMoveHistory.size() == 0) {
            return;
        }
        this.myFontMetrics = graphics.getFontMetrics();
        this.insets = this.getInsets();
        this.curWidth = this.getWidth() - this.insets.left - this.insets.right - 25 - 15;
        this.curHeight = this.getHeight() - this.insets.top - this.insets.bottom - 25 - 20;
        this.displayLeft = this.insets.left + 25;
        if (this.optMetropolisDisplay) {
            this.moveDisplayHeight = this.curHeight - 40 - 20;
            this.moveDisplayTop = this.insets.top + 25;
            this.moveDisplayBottom = this.moveDisplayTop + this.moveDisplayHeight;
            this.metroDisplayTop = this.moveDisplayBottom + 20;
            this.metroDisplayBottom = this.metroDisplayTop + 40;
        } else {
            this.moveDisplayHeight = this.curHeight;
            this.moveDisplayTop = this.insets.top + 25;
            this.moveDisplayBottom = this.moveDisplayTop + this.moveDisplayHeight;
        }
        this.logCostTop = Math.ceil(UIMoveHistory.log10(this.myMoveHistory.getMaxCost()));
        this.logCostBot = Math.floor(UIMoveHistory.log10(this.myMoveHistory.getMinCost()));
        this.costScale = (double)this.moveDisplayHeight / (this.logCostTop - this.logCostBot);
        double d = this.myMoveHistory.getInitCost();
        int n = 0;
        while (n < this.myMoveHistory.size()) {
            PMoveHistoryPoint pMoveHistoryPoint = this.myMoveHistory.get(n);
            if (this.optMetropolisDisplay) {
                this.drawMetroBar(graphics, n, pMoveHistoryPoint);
            }
            this.drawCostBar(graphics, n, d, pMoveHistoryPoint);
            if (pMoveHistoryPoint.accepted()) {
                d += pMoveHistoryPoint.getDeltaCost();
            }
            ++n;
        }
        graphics.setColor(Color.gray);
        graphics.drawLine(this.displayLeft, this.log10CostToY(this.logCostBot), this.displayLeft + this.curWidth, this.log10CostToY(this.logCostBot));
        int n2 = (int)Math.ceil(this.logCostBot);
        while (n2 <= (int)Math.floor(this.logCostTop)) {
            graphics.drawLine(this.displayLeft, this.log10CostToY(n2), this.displayLeft + this.curWidth, this.log10CostToY(n2));
            this.drawYCostLabel(graphics, n2);
            ++n2;
        }
        graphics.drawLine(this.displayLeft, this.log10CostToY(this.logCostTop), this.displayLeft + this.curWidth, this.log10CostToY(this.logCostTop));
        int n3 = 0;
        while (n3 <= this.myMoveHistory.size()) {
            int n4 = this.moveLeft(n3);
            graphics.drawLine(n4, this.moveDisplayBottom, n4, this.moveDisplayTop);
            this.drawXLabel(graphics, n3);
            n3 += 10;
        }
        this.drawYMetroLabels(graphics);
    }

    private void drawMetroRandom(Graphics graphics, int n, double d, boolean bl) {
        int n2 = this.moveLeft(n) + 1;
        int n3 = this.moveRight(n) - 1;
        int n4 = this.metroDisplayBottom - (int)(40.0 * d);
        int n5 = 3;
        this.drawTrapX[0] = n2;
        this.drawTrapY[0] = n4;
        this.drawTrapX[1] = n2 + n5;
        this.drawTrapY[1] = n4 - n5;
        this.drawTrapX[2] = n3;
        this.drawTrapY[2] = n4;
        this.drawTrapX[3] = n2 + n5;
        this.drawTrapY[3] = n4 + n5;
        if (bl) {
            graphics.setColor(lightGreen);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.fillPolygon(this.drawTrapX, this.drawTrapY, 4);
        graphics.setColor(Color.black);
        graphics.drawPolygon(this.drawTrapX, this.drawTrapY, 4);
    }

    private void drawMetroBar(Graphics graphics, int n, PMoveHistoryPoint pMoveHistoryPoint) {
        int n2 = this.moveLeft(n);
        int n3 = this.moveRight(n);
        graphics.setColor(Color.black);
        graphics.drawRect(n2, this.metroDisplayTop, 8, 40);
        if (pMoveHistoryPoint.getProbability() > 1.0) {
            System.out.println("AWK! Probability =" + pMoveHistoryPoint.getProbability());
        }
        int n4 = (int)(40.0 * pMoveHistoryPoint.getProbability());
        if (pMoveHistoryPoint.acceptedUphill()) {
            graphics.setColor(brightOrange);
            graphics.fillRect(n2 + 1, this.metroDisplayBottom - n4, 7, n4);
        } else if (pMoveHistoryPoint.accepted()) {
            graphics.setColor(lightGreen);
            graphics.fillRect(n2 + 1, this.metroDisplayTop + 1, 7, 39);
        } else {
            graphics.setColor(Color.gray);
            graphics.fillRect(n2 + 1, this.metroDisplayBottom - n4, 7, n4);
        }
        graphics.setColor(Color.black);
        if (pMoveHistoryPoint.acceptedUphill()) {
            this.drawMetroRandom(graphics, n, pMoveHistoryPoint.getR(), true);
        } else if (pMoveHistoryPoint.rejected()) {
            this.drawMetroRandom(graphics, n, pMoveHistoryPoint.getR(), false);
        }
    }

    private void drawCostBar(Graphics graphics, int n, double d, PMoveHistoryPoint pMoveHistoryPoint) {
        int n2 = this.moveLeft(n);
        int n3 = this.moveRight(n);
        this.drawTrapX[0] = this.drawTrapX[1] = n2;
        this.drawTrapX[2] = this.drawTrapX[3] = n3;
        this.drawTrapY[0] = this.drawTrapY[3] = this.moveDisplayBottom;
        this.fillTrapX[0] = this.fillTrapX[1] = n2 + 1;
        this.fillTrapX[2] = this.fillTrapX[3] = n3;
        this.fillTrapY[0] = this.fillTrapY[3] = this.moveDisplayBottom;
        this.drawTrapY[1] = this.log10CostToY(UIMoveHistory.log10(d));
        this.fillTrapY[1] = this.drawTrapY[1] + 1;
        if (pMoveHistoryPoint.accepted()) {
            this.drawTrapY[2] = this.log10CostToY(UIMoveHistory.log10(d += pMoveHistoryPoint.getDeltaCost()));
            this.fillTrapY[2] = this.drawTrapY[2] + 1;
            if (pMoveHistoryPoint.getDeltaCost() > 0.0) {
                graphics.setColor(brightOrange);
            } else {
                graphics.setColor(lightGreen);
            }
            graphics.fillPolygon(this.fillTrapX, this.fillTrapY, 4);
            graphics.setColor(Color.black);
            graphics.drawPolygon(this.drawTrapX, this.drawTrapY, 4);
        } else {
            this.drawTrapY[2] = this.drawTrapY[1];
            graphics.setColor(Color.black);
            graphics.drawPolygon(this.drawTrapX, this.drawTrapY, 4);
            graphics.setColor(Color.white);
            graphics.fillPolygon(this.fillTrapX, this.fillTrapY, 4);
            int n4 = n2 + 1;
            int n5 = n3 - 1;
            int n6 = this.log10CostToY(UIMoveHistory.log10(d + pMoveHistoryPoint.getDeltaCost()));
            graphics.setColor(Color.red);
            if (n6 < this.insets.top + 25) {
                n6 = this.insets.top + 25;
            }
            graphics.fillRect(n4, n6 - 1, 6, 3);
        }
    }
}

