/*
 * Decompiled with CFR 0.152.
 */
package placement;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import placement.PModule;
import placement.PNet;
import placement.PTerminal;
import placement.moves.PMove;

public class PLayout {
    private Vector modules = new Vector();
    private Vector nets = new Vector();
    private int curArea = 0;
    private int curRightEdge = 0;
    private int curLeftEdge = 0;
    private int curBottomEdge = 0;
    private int curTopEdge = 0;
    private int oldArea = 0;
    private int curOlap = 0;
    private int oldOlap = 0;
    private int curWirelength = 0;
    private int oldWirelength = 0;
    private int curCost = 0;
    private int oldCost = 0;
    private PModule moveModule;
    private int moveModuleNumber;
    private boolean verbose = false;
    private static final int K_OLAP = 5;
    private static final int K_NETLENGTH = 10;
    private PMove lastMove = null;

    public PLayout(String string) {
        this.readLayout(string);
        PModule.setLayout(this);
    }

    public PLayout(BufferedReader bufferedReader) throws IOException {
        this.readLayout(bufferedReader);
        PModule.setLayout(this);
    }

    public PMove getLastMove() {
        return this.lastMove;
    }

    public void selectMove() {
        this.lastMove = PMove.selectMove(this.selectModule());
    }

    public int applyMove() {
        this.lastMove.apply();
        return this.lastMove.getDeltaCost();
    }

    public void resetMoveHistory() {
        PMove.resetHistory(this.currentCost());
    }

    public boolean greedyAccept() {
        return this.lastMove.greedyAccept();
    }

    public boolean metropolisAccept(double d) {
        return this.lastMove.metropolisAccept(d);
    }

    public void rejectMove() {
        this.lastMove.reject();
    }

    public void acceptMove() {
        this.lastMove.accept();
    }

    public void completeMove() {
        this.lastMove.complete();
        this.lastMove = null;
    }

    public int calcCost() {
        this.oldCost = this.curCost;
        this.oldOlap = this.curOlap;
        this.oldWirelength = this.curWirelength;
        this.curArea = this.calcArea();
        this.curOlap = this.calcOverlap();
        this.curWirelength = this.calcWirelength();
        this.curCost = this.curArea + 10 * this.curWirelength + 5 * this.curOlap * this.curOlap;
        return this.curCost;
    }

    public int getDeltaCost() {
        return this.curCost - this.oldCost;
    }

    public int undoUpdateCost() {
        this.curArea = this.oldArea;
        this.curOlap = this.oldOlap;
        this.curWirelength = this.oldWirelength;
        this.curCost = this.oldCost;
        return this.curCost;
    }

    public int currentCost() {
        return this.curCost;
    }

    public int currentArea() {
        return this.curArea;
    }

    public int currentWidth() {
        return this.curRightEdge - this.curLeftEdge;
    }

    public int currentHeight() {
        return this.curBottomEdge - this.curTopEdge;
    }

    public int currentRightEdge() {
        return this.curRightEdge;
    }

    public int currentLeftEdge() {
        return this.curLeftEdge;
    }

    public int currentBottomEdge() {
        return this.curBottomEdge;
    }

    public int currentTopEdge() {
        return this.curTopEdge;
    }

    public int currentOverlap() {
        return this.curOlap;
    }

    public int currentWirelength() {
        return this.curWirelength;
    }

    public int calcArea() {
        int n = 0;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            PModule pModule = (PModule)enumeration.nextElement();
            n4 = Math.min(n4, pModule.leftEdge());
            n2 = Math.max(n2, pModule.rightEdge());
            n3 = Math.min(n3, pModule.topEdge());
            n = Math.max(n, pModule.bottomEdge());
        }
        this.curRightEdge = n2;
        this.curLeftEdge = n4;
        this.curBottomEdge = n;
        this.curTopEdge = n3;
        return (n - n3) * (n2 - n4);
    }

    public int calcWirelength() {
        int n = 0;
        Enumeration enumeration = this.nets.elements();
        while (enumeration.hasMoreElements()) {
            PNet pNet = (PNet)enumeration.nextElement();
            n += pNet.netLength();
        }
        return n;
    }

    public void reportCost() {
        System.out.println("area=" + this.currentArea() + " wirelength=" + this.currentWirelength() + " olap=" + this.currentOverlap() + " cost=" + this.currentCost());
    }

    public int calcOverlap() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.modules.size()) {
            PModule pModule = (PModule)this.modules.elementAt(n2);
            int n3 = n2 + 1;
            while (n3 < this.modules.size()) {
                PModule pModule2 = (PModule)this.modules.elementAt(n3);
                n += pModule.overlapArea(pModule2);
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public PModule findModule(String string) {
        int n = 0;
        while (n < this.modules.size()) {
            PModule pModule = (PModule)this.modules.elementAt(n);
            if (string.equals(pModule.getName())) {
                return pModule;
            }
            ++n;
        }
        return null;
    }

    public void addModule(PModule pModule) {
        this.modules.addElement(pModule);
    }

    public PModule getModule(int n) {
        return (PModule)this.modules.elementAt(n);
    }

    public PModule selectModule() {
        this.moveModuleNumber = (int)(Math.random() * (double)this.modules.size());
        this.moveModule = (PModule)this.modules.elementAt(this.moveModuleNumber);
        return this.moveModule;
    }

    public int getMoveModuleNumber() {
        return this.moveModuleNumber;
    }

    public int numModules() {
        return this.modules.size();
    }

    public int numNets() {
        return this.nets.size();
    }

    public PNet getNet(int n) {
        return (PNet)this.nets.elementAt(n);
    }

    public PNet findNet(String string) {
        int n = 0;
        while (n < this.nets.size()) {
            PNet pNet = (PNet)this.nets.elementAt(n);
            if (string.equals(pNet.getName())) {
                return pNet;
            }
            ++n;
        }
        return null;
    }

    public void addNet(PNet pNet) {
        if (this.nets.contains(pNet)) {
            System.out.println("Net.addNet: trying to add duplicate net: " + pNet);
        } else {
            this.nets.addElement(pNet);
        }
    }

    public void readLayout(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("module")) {
                this.addModule(PModule.parseModule(stringTokenizer));
                continue;
            }
            if (string2.equals("terminal")) {
                PTerminal.parseTerminal(stringTokenizer, this);
                continue;
            }
            if (string2.equals("net")) {
                PNet.parseNet(stringTokenizer, this);
                continue;
            }
            System.out.println("Unrecognized object: " + string2);
        }
    }

    public void readLayout(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.readLayout(bufferedReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Couldn't open file: " + string);
            System.exit(0);
        }
        catch (IOException iOException) {
            System.out.println("Caught IOException: " + iOException);
        }
    }

    public String toString() {
        String string = "PLayout [area=" + this.currentArea() + " overlap=" + this.currentOverlap() + "\n";
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            PModule pModule = (PModule)enumeration.nextElement();
            string = string + "\t" + pModule + "\n";
        }
        string = string + "]\n";
        return string;
    }

    public static void main(String[] stringArray) {
        PLayout pLayout = new PLayout(stringArray[0]);
        System.out.println(pLayout);
    }
}

