/*
 * Decompiled with CFR 0.152.
 */
package placement;

import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;
import placement.PLayout;
import placement.PModule;
import placement.PTerminal;

public class PNet {
    private Vector terminals = new Vector();
    private String name;

    public String getName() {
        return this.name;
    }

    public PNet(String string) {
        this.name = string;
    }

    public String toString() {
        String string = "PNet " + this.getName() + "[";
        int n = 0;
        while (n < this.terminals.size()) {
            PTerminal pTerminal = this.getTerminal(n);
            string = string + " " + pTerminal;
            ++n;
        }
        string = string + " ]";
        return string;
    }

    public int netLength() {
        int n;
        int n2;
        int n3 = n2 = this.getTerminal(0).getLayoutX();
        int n4 = n = this.getTerminal(0).getLayoutY();
        int n5 = 1;
        while (n5 < this.numTerminals()) {
            PTerminal pTerminal = this.getTerminal(n5);
            n2 = Math.min(n2, pTerminal.getLayoutX());
            n3 = Math.max(n3, pTerminal.getLayoutX());
            n = Math.min(n, pTerminal.getLayoutY());
            n4 = Math.max(n4, pTerminal.getLayoutY());
            ++n5;
        }
        return n4 - n + (n3 - n2);
    }

    void addTerminal(PTerminal pTerminal) {
        this.terminals.addElement(pTerminal);
    }

    public int numTerminals() {
        return this.terminals.size();
    }

    public PTerminal getTerminal(int n) {
        return (PTerminal)this.terminals.elementAt(n);
    }

    public void paintNet(Graphics graphics) {
        graphics.setColor(Color.black);
        if (this.numTerminals() <= 1) {
            return;
        }
        PTerminal pTerminal = this.getTerminal(0);
        graphics.setColor(Color.red);
        int n = 1;
        while (n < this.numTerminals()) {
            PTerminal pTerminal2 = this.getTerminal(n);
            graphics.drawLine(pTerminal.getX(), pTerminal.getY(), pTerminal2.getX(), pTerminal2.getY());
            ++n;
        }
    }

    static PNet parseNet(StringTokenizer stringTokenizer, PLayout pLayout) {
        String string = stringTokenizer.nextToken();
        PNet pNet = new PNet(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            PModule pModule = pLayout.findModule(string2);
            if (pModule == null) {
                System.out.println("Net.parseNet: could not find connecting module: " + string2);
                continue;
            }
            PTerminal pTerminal = pModule.findTerminal(string3);
            if (pTerminal == null) {
                System.out.println("Net.parseNet: could not find connecting terminal: " + string2 + ":" + string3);
                continue;
            }
            pNet.addTerminal(pTerminal);
        }
        pLayout.addNet(pNet);
        return pNet;
    }
}

