/*
 * Decompiled with CFR 0.152.
 */
package placement.anneal;

import placement.moves.PMove;

public class PTempHistoryPoint {
    private double temperature = 0.0;
    private double completedMaxCost = 0.0;
    private double completedMinCost = Double.MAX_VALUE;
    private double completedAverageCost = 0.0;
    private int completedAttemptCount = 0;
    private int completedAcceptCount = 0;
    private boolean isCompleted = false;

    public PTempHistoryPoint(double d, int n) {
        this.temperature = d;
        PMove.resetHistory(n);
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getMaxCost() {
        if (this.isCompleted) {
            return this.completedMaxCost;
        }
        return PMove.getHistory().getMaxCost();
    }

    public double getMinCost() {
        if (this.isCompleted) {
            return this.completedMinCost;
        }
        return PMove.getHistory().getMinCost();
    }

    public double getAverageCost() {
        if (this.isCompleted) {
            return this.completedAverageCost;
        }
        return PMove.getHistory().getAverageCost();
    }

    public int getAttemptCount() {
        if (this.isCompleted) {
            return this.completedAttemptCount;
        }
        return PMove.getHistory().getAttemptCount();
    }

    public int getAcceptCount() {
        if (this.isCompleted) {
            return this.completedAcceptCount;
        }
        return PMove.getHistory().getAcceptCount();
    }

    public int getRejectCount() {
        if (this.isCompleted) {
            return this.completedAttemptCount - this.completedAcceptCount;
        }
        return PMove.getHistory().getRejectCount();
    }

    public double getAcceptPercent() {
        if (this.isCompleted) {
            return (double)this.completedAcceptCount / (double)this.completedAttemptCount * 100.0;
        }
        return PMove.getHistory().getAcceptPercent();
    }

    void complete() {
        this.completedMinCost = PMove.getHistory().getMinCost();
        this.completedMaxCost = PMove.getHistory().getMaxCost();
        this.completedAverageCost = PMove.getHistory().getAverageCost();
        this.completedAttemptCount = PMove.getHistory().getAttemptCount();
        this.completedAcceptCount = PMove.getHistory().getAcceptCount();
        this.isCompleted = true;
    }
}

