/*
 * Decompiled with CFR 0.152.
 */
package placement.moves;

import placement.PModule;
import placement.moves.PMoveFlipH;
import placement.moves.PMoveFlipV;
import placement.moves.PMoveH;
import placement.moves.PMoveHistory;
import placement.moves.PMoveHistoryPoint;
import placement.moves.PMoveRotate;
import placement.moves.PMoveStatus;
import placement.moves.PMoveV;
import placement.ui.UIMove;

public abstract class PMove {
    private PMoveStatus moveStatus = PMoveStatus.MOVE_COMPLETE;
    private double acceptProbability = 0.0;
    private double acceptRandom = 0.0;
    protected int deltaCost = 0;
    protected PModule moveModule;
    private double selectionWt = 0.0;
    protected int offset = 0;
    private static final PMove[] moveArray = new PMove[]{new PMoveV(0.35), new PMoveH(0.35), new PMoveRotate(0.1), new PMoveFlipH(0.1), new PMoveFlipV(0.1)};
    private static PMoveHistory moveHistory = new PMoveHistory();
    private static int windowX = 0;
    private static int windowY = 0;
    private static double logT0 = 0.0;
    private static double windowScale = 1.0;

    public static PMoveHistory getHistory() {
        return moveHistory;
    }

    public static void resetHistory(int n) {
        moveHistory.reset(n);
    }

    public abstract UIMove getUIMove();

    public static PMove selectMove(PModule pModule) {
        PMove pMove;
        double d = Math.random();
        double d2 = 0.0;
        int n = 0;
        while (n < moveArray.length) {
            pMove = moveArray[n];
            if (d < (d2 += pMove.selectionWt)) {
                pMove.setup(pModule);
                return pMove;
            }
            ++n;
        }
        pMove = moveArray[moveArray.length - 1];
        pMove.setup(pModule);
        return pMove;
    }

    protected String moveString(String string) {
        string = string + " " + this.moveModule.getName();
        if (this.moveStatus == PMoveStatus.ACCEPT_PENDING || this.moveStatus == PMoveStatus.REJECT_PENDING) {
            string = string + " dCost=" + this.deltaCost;
        }
        return string + " [" + this.moveStatus.toString() + "]";
    }

    protected PMove(double d) {
        this.selectionWt = d;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getDeltaCost() {
        return this.deltaCost;
    }

    public PModule getMoveModule() {
        return this.moveModule;
    }

    public PMoveStatus getMoveStatus() {
        return this.moveStatus;
    }

    public double getAcceptProbability() {
        return this.acceptProbability;
    }

    public double getAcceptRandom() {
        return this.acceptRandom;
    }

    void setup(PModule pModule) {
        this.moveModule = pModule;
        this.moveStatus = PMoveStatus.MOVE_PENDING;
    }

    public void apply() {
        if (this.moveStatus != PMoveStatus.MOVE_PENDING) {
            System.out.println("PMove.apply(): must only apply NEW moves!");
        } else {
            this.moveStatus = PMoveStatus.MOVE_APPLIED;
        }
    }

    public boolean greedyAccept() {
        if (this.moveStatus != PMoveStatus.MOVE_APPLIED) {
            System.out.println("PMove.greedyAccept(): can't accept move unless applied first!");
            return false;
        }
        if (this.deltaCost < 0) {
            this.accept();
            return true;
        }
        this.reject();
        return false;
    }

    public boolean metropolisAccept(double d) {
        if (this.moveStatus != PMoveStatus.MOVE_APPLIED) {
            System.out.println("PMove.metropolisAccept(): can't accept move unless applied first!");
            return false;
        }
        if (this.deltaCost < 0 || d == Double.POSITIVE_INFINITY) {
            this.acceptProbability = 1.0;
            this.acceptRandom = 1.0;
            this.accept();
            return true;
        }
        this.acceptProbability = Math.exp((double)(-this.deltaCost) / d);
        if (this.acceptProbability > 1.0) {
            System.out.println("AWK! accept probability > 1!");
        }
        this.acceptRandom = Math.random();
        if (this.acceptRandom < this.acceptProbability) {
            this.accept();
            return true;
        }
        this.reject();
        return false;
    }

    public void accept() {
        if (this.moveStatus != PMoveStatus.MOVE_APPLIED) {
            System.out.println("PMove.accept(): can't reject move unless applied first!");
        } else {
            this.moveStatus = PMoveStatus.ACCEPT_PENDING;
            moveHistory.add(new PMoveHistoryPoint(this.deltaCost, this.acceptProbability, this.acceptRandom));
        }
    }

    public void reject() {
        if (this.moveStatus != PMoveStatus.MOVE_APPLIED) {
            System.out.println("PMove.reject(): can't reject move unless applied first!");
        } else {
            this.moveStatus = PMoveStatus.REJECT_PENDING;
            moveHistory.add(new PMoveHistoryPoint(this.deltaCost, this.acceptProbability, this.acceptRandom));
        }
    }

    public void complete() {
        if (this.moveStatus != PMoveStatus.ACCEPT_PENDING && this.moveStatus != PMoveStatus.REJECT_PENDING) {
            System.out.println("PMove.complete(): accept/reject not pending!");
        } else {
            this.moveStatus = PMoveStatus.MOVE_COMPLETE;
            this.acceptProbability = -1.0;
            this.acceptRandom = -1.0;
        }
    }

    public static void setWindow(int n, int n2) {
        windowX = n;
        windowY = n2;
    }

    public static void setT0(double d) {
        logT0 = Math.log(d);
        windowScale = 1.0;
    }

    public static void setT(double d) {
        windowScale = d == Double.POSITIVE_INFINITY ? 1.0 : Math.log(d) / logT0;
    }

    public static int genX() {
        if (windowScale <= 0.0) {
            return 1;
        }
        return (int)((double)windowX * windowScale);
    }

    public static int genY() {
        if (windowScale <= 0.0) {
            return 1;
        }
        return (int)((double)windowY * windowScale);
    }
}

