/*
 * Decompiled with CFR 0.152.
 */
package placement.moves;

import java.util.ArrayList;
import java.util.List;
import placement.moves.PMoveHistoryPoint;

public class PMoveHistory {
    private List points = new ArrayList(500);
    private int maxCost = 0;
    private int minCost = 0;
    private int initCost = 0;
    private int lastCost = 0;
    private int acceptCount = 0;
    private double sumAcceptedCost = 0.0;

    public void reset(int n) {
        this.points.clear();
        this.initCost = this.lastCost = n;
        this.minCost = this.lastCost;
        this.maxCost = this.lastCost;
        this.acceptCount = 0;
        this.sumAcceptedCost = 0.0;
    }

    public void add(PMoveHistoryPoint pMoveHistoryPoint) {
        this.points.add(pMoveHistoryPoint);
        if (pMoveHistoryPoint.accepted()) {
            ++this.acceptCount;
            this.lastCost += pMoveHistoryPoint.getDeltaCost();
            this.sumAcceptedCost += (double)this.lastCost;
            if (this.lastCost > this.maxCost) {
                this.maxCost = this.lastCost;
            }
            if (this.lastCost < this.minCost) {
                this.minCost = this.lastCost;
            }
        }
    }

    public PMoveHistoryPoint get(int n) {
        return (PMoveHistoryPoint)this.points.get(n);
    }

    public PMoveHistoryPoint getCurrent() {
        return (PMoveHistoryPoint)this.points.get(this.points.size() - 1);
    }

    public int size() {
        return this.points.size();
    }

    public int getAttemptCount() {
        return this.points.size();
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public int getRejectCount() {
        return this.getAttemptCount() - this.acceptCount;
    }

    public double getAcceptPercent() {
        if (this.getAttemptCount() == 0) {
            return 0.0;
        }
        return (double)this.getAcceptCount() / (double)this.getAttemptCount() * 100.0;
    }

    public void setInitCost(int n) {
        this.initCost = n;
        this.minCost = n;
        this.maxCost = n;
        this.lastCost = n;
    }

    public int getInitCost() {
        return this.initCost;
    }

    public int getMinCost() {
        return this.minCost;
    }

    public int getMaxCost() {
        return this.maxCost;
    }

    public int getAverageCost() {
        return (int)(this.sumAcceptedCost / (double)this.acceptCount);
    }

    public double getStdev() {
        double d = 0.0;
        int n = this.initCost;
        double d2 = this.getAverageCost();
        int n2 = 0;
        while (n2 < this.points.size()) {
            double d3 = (double)(n += ((PMoveHistoryPoint)this.points.get(n2)).getDeltaCost()) - d2;
            d += d3 * d3;
            ++n2;
        }
        return Math.sqrt(d / (double)(this.acceptCount - 1));
    }
}

