/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

public class STBOI {
    private BOIInterface ui;
    private STGraph gr;
    private ArrayList mods = new ArrayList();

    public STBOI(BOIInterface bOIInterface, STGraph sTGraph) {
        this.ui = bOIInterface;
        this.gr = sTGraph;
    }

    public STEdge findLongestEdge(STNode sTNode, STNode sTNode2, STNode sTNode3) {
        LinkedList<SearchRecord> linkedList = new LinkedList<SearchRecord>();
        this.gr.clearEdgeMarks();
        STEdge sTEdge = null;
        STEdge sTEdge2 = null;
        STNode sTNode4 = null;
        System.out.println("findLongestEdge: start= " + sTNode + " t1= " + sTNode2 + " t2= " + sTNode3);
        linkedList.add(new SearchRecord(sTNode, null));
        do {
            SearchRecord searchRecord = (SearchRecord)linkedList.removeFirst();
            System.out.println("active: n=" + searchRecord.n + " edge=" + searchRecord.e);
            if (searchRecord.n == sTNode2 || searchRecord.n == sTNode3) {
                System.out.println("found! edge=" + searchRecord.e);
                this.gr.clearEdgeMarks();
                return searchRecord.e;
            }
            for (int i = 0; i < searchRecord.n.numEdges(); ++i) {
                sTEdge = searchRecord.n.getEdge(i);
                if (sTEdge.getMark()) continue;
                sTEdge.setMark(true);
                sTNode4 = searchRecord.n == sTEdge.getP1() ? sTEdge.getP2() : sTEdge.getP1();
                sTEdge2 = searchRecord.e;
                if (sTEdge2 == null || sTEdge.length() > sTEdge2.length()) {
                    sTEdge2 = sTEdge;
                }
                linkedList.add(new SearchRecord(sTNode4, sTEdge2));
            }
        } while (linkedList.size() > 0);
        System.out.println("findLongestEdge: Couldn't find cycle!!!!");
        System.out.println("start: " + sTNode + " searching for " + sTNode2 + " or " + sTNode3);
        this.gr.clearEdgeMarks();
        return null;
    }

    public boolean improve(boolean bl) throws InterruptedException {
        int n;
        int n2;
        STEdge sTEdge = null;
        STNEPair sTNEPair = null;
        STNEPair sTNEPair2 = null;
        this.mods.clear();
        if (bl) {
            this.ui.showBOIInit();
        }
        for (n2 = 0; n2 < this.gr.numNodes(); ++n2) {
            STNode sTNode = this.gr.getNode(n2);
            System.out.println("looking at node: " + sTNode);
            sTNEPair2 = null;
            for (n = 0; n < this.gr.numEdges(); ++n) {
                sTEdge = this.gr.getEdge(n);
                System.out.println("looking at edge: " + sTEdge);
                if (sTNode.equals(sTEdge.getP1()) || sTNode.equals(sTEdge.getP2()) || !(sTNEPair = new STNEPair(sTNode, sTEdge)).getSteinerGood()) continue;
                if (sTNEPair2 == null) {
                    sTNEPair2 = sTNEPair;
                    continue;
                }
                if (sTNEPair.getCost() >= sTNEPair2.getCost()) continue;
                sTNEPair2 = sTNEPair;
            }
            if (sTNEPair2 == null) continue;
            sTNode = sTNEPair2.getNode();
            sTEdge = sTNEPair2.getEdge();
            System.out.println("best_ne: node " + sTNode + " edge " + sTEdge);
            if (sTEdge == null) continue;
            STEdge sTEdge2 = this.findLongestEdge(sTNode, sTEdge.getP1(), sTEdge.getP2());
            System.out.println("maxEdge: " + sTEdge2);
            sTNEPair2.setElimEdge(sTEdge2);
            if (bl) {
                this.ui.showNEGain(sTNEPair2);
            }
            if (sTNEPair2.getGain() <= 0) continue;
            System.out.println("Node " + n2 + " " + sTNode + " new mod " + sTNEPair2);
            this.mods.add(sTNEPair2);
        }
        Collections.sort(this.mods);
        n2 = 0;
        for (n = 0; n < this.mods.size(); ++n) {
            STNEPair sTNEPair3 = (STNEPair)this.mods.get(n);
            System.out.println(this.gr);
            System.out.println("applying mod " + n + " " + sTNEPair3);
            if (!sTNEPair3.modValid()) continue;
            if (bl) {
                this.ui.showNEMod(sTNEPair3);
            }
            sTNEPair3.applyMod(this.gr);
            n2 = 1;
            if (!bl) continue;
            this.ui.showNEModComplete();
        }
        this.gr.purgeDeletedEdges();
        if (bl) {
            this.ui.showBOIComplete(n2 != 0);
        }
        return n2 != 0;
    }

    class SearchRecord {
        STNode n;
        STEdge e;

        public SearchRecord(STNode sTNode, STEdge sTEdge) {
            this.n = sTNode;
            this.e = sTEdge;
        }
    }
}

