/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

public class STGraph {
    private Vector nodes = new Vector();
    private Vector edges = new Vector();

    public void addNode(STNode sTNode) {
        this.nodes.add(sTNode);
    }

    public void addRandomNodes(int n, int n2, int n3) {
        n2 -= 10;
        n3 -= 10;
        int n4 = 5;
        int n5 = 5;
        for (int i = 0; i < n; ++i) {
            int n6 = n4 + (int)(Math.random() * (double)n2);
            int n7 = n5 + (int)(Math.random() * (double)n3);
            this.addNode(new STNode(new Point(n6, n7)));
        }
    }

    public void removeNode(STNode sTNode) {
        this.nodes.remove(sTNode);
        for (int i = this.numEdges() - 1; i >= 0; --i) {
            STEdge sTEdge = this.getEdge(i);
            if (sTEdge.getP1() != sTNode && sTEdge.getP2() != sTNode) continue;
            sTEdge.disconnect();
            this.edges.remove(sTEdge);
        }
    }

    public void removeNonTerminalNodes() {
        for (int i = this.numNodes() - 1; i >= 0; --i) {
            STNode sTNode = this.getNode(i);
            if (sTNode.isTerminal()) continue;
            this.removeNode(sTNode);
        }
    }

    public STNode getNode(int n) {
        return (STNode)this.nodes.elementAt(n);
    }

    public STNode findNode(Point point, int n) {
        for (int i = 0; i < this.numNodes(); ++i) {
            STNode sTNode = this.getNode(i);
            if (!sTNode.nodeFound(point, n)) continue;
            return sTNode;
        }
        return null;
    }

    public Point snapSteiner(Point point) {
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < this.numNodes(); ++i) {
            int n5;
            STNode sTNode = this.getNode(i);
            int n6 = Math.abs(point.x - sTNode.getLocation().x);
            if (n6 < n2) {
                n2 = n6;
                n = sTNode.getLocation().x;
            }
            if ((n5 = Math.abs(point.y - sTNode.getLocation().y)) >= n4) continue;
            n4 = n5;
            n3 = sTNode.getLocation().y;
        }
        if (n < 0 || n3 < 0) {
            return null;
        }
        return new Point(n, n3);
    }

    public Point findSteiner(Point point, int n) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < this.numNodes(); ++i) {
            STNode sTNode = this.getNode(i);
            if (sTNode.nodeMatchX(point, n)) {
                n2 = sTNode.getLocation().x;
            }
            if (sTNode.nodeMatchY(point, n)) {
                n3 = sTNode.getLocation().y;
            }
            if (n2 <= 0 || n3 <= 0) continue;
            return new Point(n2, n3);
        }
        return null;
    }

    public int numNodes() {
        return this.nodes.size();
    }

    public void addEdge(STEdge sTEdge) {
        this.edges.add(sTEdge);
    }

    public void addEdge(STNode sTNode, STNode sTNode2) {
        STEdge sTEdge = new STEdge(sTNode, sTNode2);
        this.addEdge(sTEdge);
        sTNode.addEdge(sTEdge);
        sTNode2.addEdge(sTEdge);
    }

    public void clearVisited() {
        for (int i = 0; i < this.numNodes(); ++i) {
            STNode sTNode = this.getNode(i);
            sTNode.setVisited(false);
        }
    }

    public void clearEdges() {
        for (int i = 0; i < this.numEdges(); ++i) {
            STEdge sTEdge = this.getEdge(i);
            sTEdge.disconnect();
        }
        this.edges.clear();
    }

    public void clearEdgeMarks() {
        for (int i = 0; i < this.numEdges(); ++i) {
            this.getEdge(i).setMark(false);
        }
    }

    public void purgeDeletedEdges() {
        for (int i = this.numEdges() - 1; i >= 0; --i) {
            STEdge sTEdge = this.getEdge(i);
            if (!sTEdge.getDeleteMark()) continue;
            this.edges.remove(sTEdge);
        }
    }

    public STEdge getEdge(int n) {
        return (STEdge)this.edges.elementAt(n);
    }

    public int numEdges() {
        return this.edges.size();
    }

    public int edgeLength() {
        int n = 0;
        for (int i = 0; i < this.numEdges(); ++i) {
            n += this.getEdge(i).length();
        }
        return n;
    }

    public int halfPerim() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.numNodes(); ++i) {
            STNode sTNode = this.getNode(i);
            int n5 = sTNode.getLocation().x;
            int n6 = sTNode.getLocation().y;
            n = Math.min(n, n5);
            n2 = Math.min(n2, n6);
            n3 = Math.max(n3, n5);
            n4 = Math.max(n4, n6);
        }
        return n3 - n + (n4 - n2);
    }

    public void clearGraph() {
        this.edges.clear();
        this.nodes.clear();
    }

    public String toString() {
        int n;
        String string = "Graph: ";
        for (n = 0; n < this.numNodes(); ++n) {
            string = string + "\n    " + this.getNode(n);
        }
        for (n = 0; n < this.numEdges(); ++n) {
            string = string + "\n    " + this.getEdge(n);
        }
        return string;
    }

    public void readGraph(BufferedReader bufferedReader) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.parseNumbers();
        int n = 0;
        if (streamTokenizer.nextToken() != -2) {
            System.out.println("STGraph.readGraph(): unexpected token " + streamTokenizer);
            return;
        }
        int n2 = (int)streamTokenizer.nval;
        while (streamTokenizer.nextToken() == -2) {
            int n3 = (int)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2) {
                System.out.println("STGraph.readGraph(): unexpected token " + streamTokenizer);
                return;
            }
            int n4 = (int)streamTokenizer.nval;
            this.addNode(new STNode(n3, n4));
            ++n;
        }
        if (n != n2) {
            System.out.println("STRraph.readGraph: expected " + n2 + " nodes actually read " + n);
        }
    }

    public static void main(String[] stringArray) {
        STGraph sTGraph = new STGraph();
        STNode sTNode = new STNode(5, 5);
        STNode sTNode2 = new STNode(100, 100);
        STNode sTNode3 = new STNode(150, 200);
        STEdge sTEdge = new STEdge(sTNode, sTNode2);
        STEdge sTEdge2 = new STEdge(sTNode, sTNode3);
        sTGraph.addNode(sTNode);
        sTGraph.addNode(sTNode2);
        sTGraph.addNode(sTNode3);
        sTGraph.addEdge(sTEdge);
        sTGraph.addEdge(sTEdge2);
        System.out.println(sTGraph);
    }
}

