/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;

public class STNEPair
implements Comparable {
    private STNode node;
    private STEdge edge;
    private Point steinerPoint;
    private boolean steinerGood;
    private int cost;
    private int gain;
    private STEdge elimEdge;

    public STNEPair(STNode sTNode, STEdge sTEdge) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.node = sTNode;
        this.edge = sTEdge;
        Point point = this.edge.getP1().getLocation();
        Point point2 = this.edge.getP2().getLocation();
        Point point3 = this.node.getLocation();
        if (point.x < point2.x) {
            n8 = point.x;
            n7 = point2.x;
        } else {
            n8 = point2.x;
            n7 = point.x;
        }
        if (point3.x < n8) {
            n6 = n8 - point3.x;
            n5 = n8;
        } else if (point3.x > n7) {
            n6 = point3.x - n7;
            n5 = n7;
        } else {
            n6 = 0;
            n5 = point3.x;
        }
        if (point.y < point2.y) {
            n4 = point.y;
            n3 = point2.y;
        } else {
            n4 = point2.y;
            n3 = point.y;
        }
        if (point3.y < n4) {
            n2 = n4 - point3.y;
            n = n4;
        } else if (point3.y > n3) {
            n2 = point3.y - n3;
            n = n3;
        } else {
            n2 = 0;
            n = point3.y;
        }
        this.steinerPoint = new Point(n5, n);
        this.steinerGood = !this.steinerPoint.equals(point) && !this.steinerPoint.equals(point2) && !this.steinerPoint.equals(point3);
        this.cost = n6 + n2;
    }

    public int getCost() {
        return this.cost;
    }

    public int getGain() {
        return this.gain;
    }

    public int setElimEdge(STEdge sTEdge) {
        this.elimEdge = sTEdge;
        this.gain = this.elimEdge.length() - this.cost;
        return this.gain;
    }

    public STNode getNode() {
        return this.node;
    }

    public STEdge getEdge() {
        return this.edge;
    }

    public STEdge getElimEdge() {
        return this.elimEdge;
    }

    public Point getSteiner() {
        return this.steinerPoint;
    }

    public boolean getSteinerGood() {
        return this.steinerGood;
    }

    public boolean modValid() {
        return this.gain > 0 && !this.edge.getDeleteMark() && !this.elimEdge.getDeleteMark();
    }

    public boolean applyMod(STGraph sTGraph) {
        if (!this.modValid()) {
            return false;
        }
        STNode sTNode = new STNode(this.steinerPoint, false);
        sTGraph.addNode(sTNode);
        System.out.println("disconnecting " + this.elimEdge);
        this.elimEdge.disconnect();
        System.out.println("Graph after elimEdge disconnect: " + sTGraph);
        STNode sTNode2 = this.edge.getP1();
        STNode sTNode3 = this.edge.getP2();
        System.out.println("disconnecting " + this.edge);
        this.edge.disconnect();
        System.out.println("Graph after edge disconnect: " + sTGraph);
        sTGraph.addEdge(sTNode2, sTNode);
        sTGraph.addEdge(sTNode3, sTNode);
        sTGraph.addEdge(this.node, sTNode);
        return true;
    }

    public int compareTo(Object object) {
        STNEPair sTNEPair = (STNEPair)object;
        if (this.getGain() == sTNEPair.getGain()) {
            return 0;
        }
        if (this.getGain() < sTNEPair.getGain()) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "STNEPair: node " + this.node + " edge " + this.edge + " elimEdge " + this.elimEdge + " gain " + this.gain;
    }
}

