/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.LinkedList;

public class STNode {
    private Point loc;
    private boolean isTerm;
    private boolean visitFlag = false;
    private LinkedList edges = new LinkedList();

    public STNode(Point point, boolean bl) {
        this.loc = point;
        this.isTerm = bl;
    }

    public STNode(Point point) {
        this(point, true);
    }

    public STNode(int n, int n2) {
        this(new Point(n, n2));
    }

    public Point getLocation() {
        return this.loc;
    }

    public void setLocation(Point point) {
        this.loc = point;
    }

    public boolean nodeFound(Point point, int n) {
        int n2 = point.x - n / 2;
        int n3 = point.y - n / 2;
        int n4 = point.x + n / 2;
        int n5 = point.y + n / 2;
        return this.loc.x > n2 && this.loc.x < n4 && this.loc.y > n3 && this.loc.y < n5;
    }

    public boolean nodeMatchX(Point point, int n) {
        int n2 = point.x - n / 2;
        int n3 = point.x + n / 2;
        return this.loc.x > n2 && this.loc.x < n3;
    }

    public boolean nodeMatchY(Point point, int n) {
        int n2 = point.y - n / 2;
        int n3 = point.y + n / 2;
        return this.loc.y > n2 && this.loc.y < n3;
    }

    public boolean isTerminal() {
        return this.isTerm;
    }

    public void setVisited(boolean bl) {
        this.visitFlag = bl;
    }

    public boolean isVisited() {
        return this.visitFlag;
    }

    public int distanceL1(STNode sTNode) {
        return Math.abs(this.loc.x - sTNode.loc.x) + Math.abs(this.loc.y - sTNode.loc.y);
    }

    public void addEdge(STEdge sTEdge) {
        this.edges.add(sTEdge);
    }

    public void removeEdge(STEdge sTEdge) {
        this.edges.remove(sTEdge);
    }

    public STEdge getEdge(int n) {
        return (STEdge)this.edges.get(n);
    }

    public int numEdges() {
        return this.edges.size();
    }

    public String toString() {
        String string = "Node(" + this.loc.x + "," + this.loc.y + "){";
        for (int i = 0; i < this.edges.size(); ++i) {
            string = string + this.getEdge(i);
        }
        string = string + "}";
        return string;
    }
}

