/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class UIAnimationController
extends JPanel
implements Runnable,
ActionListener {
    public static final int STOP = 0;
    public static final int RUN = 1;
    public static final int PAUSE = 2;
    public static final int STEP = 3;
    private int state = 0;
    private boolean animate = true;
    private Thread runner = null;
    UIAnimated ua;
    private int optSpeed = 50;
    private JToggleButton stopButton;
    private JToggleButton runButton;
    private JToggleButton pauseButton;
    private JToggleButton stepButton;
    private ButtonGroup bg = new ButtonGroup();
    public static final long serialVersionUID = 1L;
    private static int ANIMATE_DELAY = 12000;

    public void SetAnimated(UIAnimated uIAnimated) {
        this.ua = uIAnimated;
    }

    public int getState() {
        return this.state;
    }

    public void setOptSpeed(int n) {
        this.optSpeed = n;
    }

    public int getOptSpeed() {
        return this.optSpeed;
    }

    public UIAnimationController(UIAnimated uIAnimated) {
        this.ua = uIAnimated;
        this.stopButton = new JToggleButton(new ImageIcon(this.getClass().getResource("images/stop.gif")), true);
        this.runButton = new JToggleButton(new ImageIcon(this.getClass().getResource("images/start.gif")));
        this.pauseButton = new JToggleButton(new ImageIcon(this.getClass().getResource("images/pause.gif")));
        this.stepButton = new JToggleButton(new ImageIcon(this.getClass().getResource("images/step.gif")));
        this.stopButton.setToolTipText("Stop");
        this.runButton.setToolTipText("Start");
        this.pauseButton.setToolTipText("Pause");
        this.stepButton.setToolTipText("Single Step");
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new FlowLayout(0));
        this.bg.add(this.stopButton);
        this.bg.add(this.runButton);
        this.bg.add(this.pauseButton);
        this.bg.add(this.stepButton);
        this.stopButton.setActionCommand("STOP");
        this.runButton.setActionCommand("RUN");
        this.pauseButton.setActionCommand("PAUSE");
        this.stepButton.setActionCommand("STEP");
        this.stopButton.addActionListener(this);
        this.runButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.stepButton.addActionListener(this);
        this.add(Box.createHorizontalGlue());
        this.add(this.stopButton);
        this.add(this.runButton);
        this.add(this.pauseButton);
        this.add(this.stepButton);
        this.add(Box.createHorizontalGlue());
    }

    public void interruptAnimation() {
        this.state = 0;
        if (this.runner != null) {
            this.runner.interrupt();
            this.runner = null;
        }
    }

    public void enableAnimation() {
        this.stopButton.setSelected(true);
        this.stopButton.setEnabled(true);
        this.runButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.stepButton.setEnabled(true);
    }

    public void disableAnimation() {
        this.interruptAnimation();
        this.stopButton.setEnabled(false);
        this.runButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.stepButton.setEnabled(false);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "STOP") {
            this.stopButton.setSelected(true);
            this.runButton.setEnabled(true);
            this.pauseButton.setEnabled(false);
            this.stepButton.setEnabled(true);
            this.interruptAnimation();
        } else if (string == "RUN") {
            this.pauseButton.setEnabled(true);
            this.stepButton.setEnabled(false);
            if (this.state == 0) {
                if (this.runner == null) {
                    this.runner = new Thread(this);
                    this.runner.start();
                    this.state = 1;
                } else {
                    System.out.println("trying to start but non-null thread");
                }
                this.state = 1;
            } else if (this.state == 2) {
                this.state = 1;
                this.notifyAll();
            }
        } else if (string == "PAUSE") {
            if (this.state == 0) {
                this.stopButton.setSelected(true);
            } else {
                this.stepButton.setEnabled(true);
                this.state = 2;
            }
        } else if (string == "STEP") {
            if (this.state == 0) {
                this.pauseButton.setEnabled(true);
                this.runner = new Thread(this);
                this.runner.start();
                this.state = 3;
            } else {
                this.state = 3;
                this.notifyAll();
            }
        }
    }

    public void setStop() {
        this.state = 0;
        this.stopButton.setSelected(true);
        this.runButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.stepButton.setEnabled(true);
    }

    public void run() {
        try {
            this.ua.runAnimation();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setStop();
        this.runner = null;
    }

    public synchronized void stop() {
        this.runButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.state = 0;
        this.ua.stopAnimation();
        if (this.runner != null) {
            this.runner.interrupt();
            this.runner = null;
        }
    }

    public synchronized void animateDelay(int n) throws InterruptedException {
        Thread.sleep(n * ANIMATE_DELAY / this.optSpeed);
        if (this.state == 3) {
            this.state = 2;
            this.pauseButton.setSelected(true);
        }
        while (this.state == 2) {
            this.wait();
        }
    }

    public synchronized void animateDelay() throws InterruptedException {
        this.animateDelay(1);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Control Panel Test");
        jFrame.setSize(300, 300);
        jFrame.setVisible(true);
        UIAnimationController uIAnimationController = new UIAnimationController(null);
        jFrame.add(uIAnimationController);
        for (int i = 1; i < 1000; ++i) {
            try {
                Thread.sleep(600L);
                System.out.println("State = " + uIAnimationController.state);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

