/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UIGraph
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected STGraph gr;
    public static final long serialVersionUID = 1L;
    protected UIGraphChangeListener changeListener;
    protected static final int TERM_SIZE = 8;
    protected STNode selNode = null;
    protected STEdge selEdge = null;

    public UIGraph(STGraph sTGraph, UIGraphChangeListener uIGraphChangeListener) {
        this.gr = sTGraph;
        this.changeListener = uIGraphChangeListener;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public UIGraph(STGraph sTGraph) {
        this(sTGraph, null);
    }

    private void drawNode(Graphics graphics, STNode sTNode, boolean bl) {
        Point point = sTNode.getLocation();
        int n = point.x - 4;
        int n2 = point.y - 4;
        Color color = bl ? Color.blue : (sTNode.isVisited() ? Color.green : Color.blue);
        graphics.setColor(color);
        if (sTNode.isTerminal()) {
            graphics.fillRect(n, n2, 8, 8);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, 8, 8);
        } else {
            graphics.fillOval(n, n2, 8, 8);
            graphics.setColor(Color.black);
            graphics.drawOval(n, n2, 8, 8);
        }
    }

    private void drawEdge(Graphics graphics, STEdge sTEdge) {
        if (sTEdge.getDeleteMark()) {
            return;
        }
        Point point = sTEdge.getP1().getLocation();
        Point point2 = sTEdge.getP2().getLocation();
        if (sTEdge == this.selEdge) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(Color.red);
        }
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.setColor(Color.black);
    }

    protected void drawEdges(Graphics graphics) {
        for (int i = 0; i < this.gr.numEdges(); ++i) {
            STEdge sTEdge = this.gr.getEdge(i);
            this.drawEdge(graphics, sTEdge);
        }
    }

    protected void drawNodes(Graphics graphics) {
        for (int i = 0; i < this.gr.numNodes(); ++i) {
            STNode sTNode;
            this.drawNode(graphics, sTNode, (sTNode = this.gr.getNode(i)) == this.selNode);
        }
    }

    public void selectNode(STNode sTNode) {
        this.selNode = sTNode;
    }

    public void selectEdge(STEdge sTEdge) {
        this.selEdge = sTEdge;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawEdges(graphics);
        this.drawNodes(graphics);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.selNode = this.gr.findNode(point, 8);
        if (this.selNode == null) {
            this.selNode = new STNode(point);
            this.gr.addNode(this.selNode);
        } else if (mouseEvent.isControlDown()) {
            this.gr.removeNode(this.selNode);
            this.selNode = null;
        }
        if (this.changeListener != null) {
            this.changeListener.graphChanged();
        }
        this.getParent().repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.selNode = null;
        if (this.changeListener != null) {
            this.changeListener.graphChanged();
        }
        this.getParent().repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selNode != null) {
            this.selNode.setLocation(mouseEvent.getPoint());
            if (this.changeListener != null) {
                this.changeListener.graphChanged();
            }
            this.getParent().repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        STGraph sTGraph = new STGraph();
        UIGraph uIGraph = new UIGraph(sTGraph);
        JFrame jFrame = new JFrame();
        jFrame.add(uIGraph);
        jFrame.setSize(250, 250);
        jFrame.setVisible(true);
        STNode sTNode = new STNode(5, 5);
        STNode sTNode2 = new STNode(100, 100);
        STNode sTNode3 = new STNode(150, 250);
        sTGraph.addNode(sTNode);
        sTGraph.addNode(sTNode2);
        sTGraph.addNode(sTNode3);
        jFrame.repaint();
    }
}

