/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;

public class UIHananGraph
extends UIGraph
implements MouseListener,
MouseMotionListener {
    private boolean hananMode = false;
    private STNEPair selectedNEPair = null;

    public UIHananGraph(STGraph sTGraph, UIGraphChangeListener uIGraphChangeListener) {
        super(sTGraph, uIGraphChangeListener);
    }

    public UIHananGraph(STGraph sTGraph) {
        this(sTGraph, null);
    }

    public void setHananMode(boolean bl) {
        this.hananMode = bl;
    }

    public boolean getHananMode() {
        return this.hananMode;
    }

    public void selectNEPair(STNEPair sTNEPair) {
        this.selectedNEPair = sTNEPair;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.hananMode) {
            super.mousePressed(mouseEvent);
        } else {
            Point point = mouseEvent.getPoint();
            this.selNode = this.gr.findNode(point, 8);
            if (this.selNode != null) {
                if (this.selNode.isTerminal()) {
                    return;
                }
                if (mouseEvent.isControlDown()) {
                    this.gr.removeNode(this.selNode);
                    this.selNode = null;
                }
            } else {
                Point point2 = this.gr.findSteiner(point, 8);
                if (point2 == null) {
                    return;
                }
                this.selNode = new STNode(point2, false);
                this.gr.addNode(this.selNode);
            }
            if (this.changeListener != null) {
                this.changeListener.graphChanged();
            }
            this.getParent().repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.hananMode) {
            super.mouseReleased(mouseEvent);
        } else {
            this.selNode = null;
        }
        this.getParent().repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.hananMode) {
            super.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void drawBBox(Graphics graphics, Point point, Point point2) {
        int n = Math.min(point.x, point2.x);
        int n2 = Math.max(point.x, point2.x);
        int n3 = Math.min(point.y, point2.y);
        int n4 = Math.max(point.y, point2.y);
        graphics.drawRect(n, n3, n2 - n, n4 - n3);
    }

    public void drawNEPair(Graphics graphics, STNEPair sTNEPair) {
        STEdge sTEdge = sTNEPair.getEdge();
        graphics.setColor(Color.yellow);
        this.drawBBox(graphics, sTEdge.getP1().getLocation(), sTEdge.getP2().getLocation());
        if (sTNEPair.getNode() == null || sTNEPair.getSteiner() == null) {
            return;
        }
        Point point = sTNEPair.getNode().getLocation();
        graphics.drawLine(point.x, point.y, sTNEPair.getSteiner().x, sTNEPair.getSteiner().y);
    }

    public void drawHananGrid(Graphics graphics) {
        STNode sTNode;
        int n;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        for (n = 0; n < this.gr.numNodes(); ++n) {
            sTNode = this.gr.getNode(n);
            n2 = Math.min(n2, sTNode.getLocation().x);
            n3 = Math.max(n3, sTNode.getLocation().x);
            n4 = Math.min(n4, sTNode.getLocation().y);
            n5 = Math.max(n5, sTNode.getLocation().y);
        }
        for (n = 0; n < this.gr.numNodes(); ++n) {
            sTNode = this.gr.getNode(n);
            if (!sTNode.isTerminal()) continue;
            int n6 = sTNode.getLocation().x;
            int n7 = sTNode.getLocation().y;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n6, n4, n6, n5);
            graphics.drawLine(n2, n7, n3, n7);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (!this.hananMode) {
            super.paintComponent(graphics);
        } else {
            this.drawHananGrid(graphics);
            this.drawEdges(graphics);
            this.drawNodes(graphics);
        }
        if (this.selectedNEPair != null) {
            this.drawNEPair(graphics, this.selectedNEPair);
        }
    }

    public static void main(String[] stringArray) {
        STGraph sTGraph = new STGraph();
        UIHananGraph uIHananGraph = new UIHananGraph(sTGraph);
        uIHananGraph.setHananMode(true);
        JFrame jFrame = new JFrame();
        jFrame.add(uIHananGraph);
        jFrame.setSize(4000, 400);
        jFrame.setVisible(true);
        sTGraph.addRandomNodes(10, 300, 200);
        jFrame.repaint();
    }
}

