/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class UIPrimMST
extends JPanel
implements PrimMSTInterface,
UIAnimated,
ActionListener,
UIGraphChangeListener {
    private STGraph gr;
    private UIGraph ugr;
    private STPrimMST prim;
    private JPanel statusPanel;
    private JPanel controlPanel;
    private UIValDisplay halfPerimDisplay;
    private UIValDisplay lengthDisplay;
    private boolean animate = true;
    private UIAnimationController ucontrol;
    public static final long serialVersionUID = 1L;
    private JToggleButton autoButton;
    private boolean autoMode = false;

    public UIPrimMST() {
        this.setLayout(new BorderLayout());
        this.gr = new STGraph();
        this.ugr = new UIGraph(this.gr, this);
        this.prim = new STPrimMST(this, this.gr);
        this.ucontrol = new UIAnimationController(this);
        this.autoButton = new JToggleButton("AUTO");
        this.autoButton.setActionCommand("AUTO");
        this.autoButton.setToolTipText("Auto-Update on Edit");
        this.autoButton.addActionListener(this);
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new GridLayout(1, 2));
        this.halfPerimDisplay = new UIValDisplay("Half Perimeter", 0);
        this.statusPanel.add(this.halfPerimDisplay);
        this.lengthDisplay = new UIValDisplay("Edge Length", 0);
        this.statusPanel.add(this.lengthDisplay);
        this.add((Component)this.statusPanel, "North");
        this.add((Component)this.ugr, "Center");
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new FlowLayout());
        this.controlPanel.add(this.ucontrol);
        this.controlPanel.add(this.autoButton);
        this.add((Component)this.controlPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public void setCostDisplay() {
        this.halfPerimDisplay.setValue(this.gr.halfPerim());
        this.lengthDisplay.setValue(this.gr.edgeLength());
    }

    public void initRandom() {
        int n = this.ugr.getWidth();
        int n2 = this.ugr.getHeight();
        this.gr.clearGraph();
        this.gr.addRandomNodes(10, n, n2);
        try {
            this.prim.primMST(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void readGraph(BufferedReader bufferedReader) throws IOException {
        this.gr.readGraph(bufferedReader);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.setCostDisplay();
    }

    public void runAnimation() throws InterruptedException {
        this.prim.primMST(true);
    }

    public void stopAnimation() {
        this.ucontrol.interruptAnimation();
    }

    public void displayPartialTree() throws InterruptedException {
        this.repaint();
        this.ucontrol.animateDelay();
    }

    public void displayDistances() throws InterruptedException {
    }

    public void displayClosestNode(STNode sTNode) throws InterruptedException {
        this.ugr.selectNode(sTNode);
        this.repaint();
        this.ucontrol.animateDelay();
        this.ugr.selectNode(null);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "AUTO") {
            if (this.autoButton.isSelected()) {
                this.autoMode = true;
                this.ucontrol.disableAnimation();
                this.ugr.selectNode(null);
                try {
                    this.prim.primMST(false);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.repaint();
            } else {
                this.autoMode = false;
                this.ucontrol.enableAnimation();
            }
        }
    }

    public void graphChanged() {
        if (this.autoMode) {
            try {
                this.prim.primMST(false);
                this.repaint();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.ucontrol.interruptAnimation();
            this.gr.clearEdges();
            this.gr.clearVisited();
            this.repaint();
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        UIPrimMST uIPrimMST = new UIPrimMST();
        jFrame.setSize(300, 300);
        jFrame.getContentPane().add(uIPrimMST);
        jFrame.setVisible(true);
    }
}

