/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UISteinerBOI
extends JPanel
implements BOIInterface,
UIAnimated,
UIGraphChangeListener {
    private STGraph gr;
    private UIHananGraph ugr;
    private STPrimMST prim;
    private STBOI boi;
    private JPanel statusPanel;
    private JPanel controlPanel;
    private JLabel messageLabel;
    private UIValDisplay halfPerimDisplay;
    private UIValDisplay lengthDisplay;
    private UIAnimationController ucontrol;
    public static final long serialVersionUID = 1L;

    public UISteinerBOI() {
        this.setLayout(new BorderLayout());
        this.gr = new STGraph();
        this.ugr = new UIHananGraph(this.gr, this);
        this.prim = new STPrimMST(null, this.gr);
        this.boi = new STBOI(this, this.gr);
        this.ucontrol = new UIAnimationController(this);
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new GridLayout(1, 2));
        this.halfPerimDisplay = new UIValDisplay("Half Perimeter", 0);
        this.statusPanel.add(this.halfPerimDisplay);
        this.lengthDisplay = new UIValDisplay("Edge Length", 0);
        this.statusPanel.add(this.lengthDisplay);
        this.add((Component)this.statusPanel, "North");
        this.add((Component)this.ugr, "Center");
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new FlowLayout(0));
        this.controlPanel.add(this.ucontrol);
        this.messageLabel = new JLabel("");
        this.controlPanel.add(this.messageLabel);
        this.add((Component)this.controlPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public void setCostDisplay() {
        this.halfPerimDisplay.setValue(this.gr.halfPerim());
        this.lengthDisplay.setValue(this.gr.edgeLength());
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string);
    }

    public void initRandom() {
        int n = this.ugr.getWidth();
        int n2 = this.ugr.getHeight();
        this.gr.clearGraph();
        this.gr.addRandomNodes(10, n, n2);
        try {
            this.prim.primMST(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void readGraph(BufferedReader bufferedReader) throws IOException {
        this.gr.readGraph(bufferedReader);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.setCostDisplay();
    }

    public void runAnimation() throws InterruptedException {
        this.boi.improve(true);
    }

    public void stopAnimation() {
        this.ucontrol.interruptAnimation();
    }

    public void showBOIInit() throws InterruptedException {
        System.out.println("showBOIInit");
        this.ugr.selectNode(null);
        this.ugr.selectEdge(null);
        this.setMessage("Starting BOI improve phase");
        this.repaint();
        this.ucontrol.animateDelay();
        this.setMessage(null);
    }

    public void showNEPair(STNEPair sTNEPair) throws InterruptedException {
        System.out.println("showNEPair - node " + sTNEPair.getNode() + " edge " + sTNEPair.getEdge());
        this.ugr.selectNEPair(null);
        this.ugr.selectNode(sTNEPair.getNode());
        this.ugr.selectEdge(sTNEPair.getEdge());
        this.setMessage("Pair Candidate");
        this.repaint();
        this.ucontrol.animateDelay();
    }

    public void showNEGain(STNEPair sTNEPair) throws InterruptedException {
        System.out.println("showNEGain - node " + sTNEPair.getNode() + " elimEdge " + sTNEPair.getElimEdge() + " gain " + sTNEPair.getGain());
        this.ugr.selectNode(sTNEPair.getNode());
        this.ugr.selectEdge(sTNEPair.getElimEdge());
        this.ugr.selectNEPair(sTNEPair);
        this.setMessage("node/edge gain: " + sTNEPair.getGain());
        this.repaint();
        this.ucontrol.animateDelay();
    }

    public void showNEMod(STNEPair sTNEPair) throws InterruptedException {
        this.ugr.selectNode(null);
        this.ugr.selectEdge(null);
        this.ugr.selectNEPair(sTNEPair);
        this.setMessage("Applying modification gain=" + sTNEPair.getGain());
        this.repaint();
        this.ucontrol.animateDelay();
    }

    public void showNEModComplete() throws InterruptedException {
        this.ugr.selectNEPair(null);
        this.setMessage("Modification complete");
        this.repaint();
        this.ucontrol.animateDelay();
    }

    public void showBOIComplete(boolean bl) throws InterruptedException {
        this.ugr.selectNEPair(null);
        if (bl) {
            this.setMessage("Pass completed");
        } else {
            this.setMessage("Pass completed (no improvemnt)");
        }
        this.repaint();
        this.ucontrol.animateDelay();
    }

    public void displayDistances() throws InterruptedException {
    }

    public void displayClosestNode(STNode sTNode) throws InterruptedException {
        this.ugr.selectNode(sTNode);
        this.repaint();
        this.ucontrol.animateDelay();
        this.ugr.selectNode(null);
    }

    public void graphChanged() {
        this.ucontrol.interruptAnimation();
        try {
            this.prim.primMST(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        UISteinerBOI uISteinerBOI = new UISteinerBOI();
        jFrame.setSize(400, 300);
        jFrame.getContentPane().add(uISteinerBOI);
        jFrame.setVisible(true);
        uISteinerBOI.initRandom();
    }
}

