/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class UISteinerDemo
extends JPanel
implements ActionListener,
UIGraphChangeListener {
    private STGraph gr;
    private UIHananGraph ugr;
    private STPrimMST prim;
    private JPanel statusPanel;
    private JPanel controlPanel;
    private UIValDisplay halfPerimDisplay;
    private UIValDisplay lengthDisplay;
    private UIValDisplay improveDisplay;
    private JToggleButton steinerModeButton;
    private boolean steinerMode = false;
    private int rmstLength = 0;

    public UISteinerDemo() {
        this.setLayout(new BorderLayout());
        this.gr = new STGraph();
        this.ugr = new UIHananGraph(this.gr, this);
        this.prim = new STPrimMST(null, this.gr);
        this.steinerModeButton = new JToggleButton("STMODE");
        this.steinerModeButton.setActionCommand("STMODE");
        this.steinerModeButton.setToolTipText("Editing Terminals - Click to Edit Steiner Points");
        this.steinerModeButton.addActionListener(this);
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new GridLayout(1, 2));
        this.halfPerimDisplay = new UIValDisplay("Half Perimeter", 0);
        this.halfPerimDisplay.setToolTipText("Half Perimeter Length Estimate");
        this.statusPanel.add(this.halfPerimDisplay);
        this.lengthDisplay = new UIValDisplay("Edge Length", 0);
        this.lengthDisplay.setToolTipText("Edge Length of Current Tree");
        this.statusPanel.add(this.lengthDisplay);
        this.improveDisplay = new UIValDisplay("Improvement", 1, 1, 2);
        this.improveDisplay.setToolTipText("Improvement Factor over RMST");
        this.statusPanel.add(this.improveDisplay);
        this.add((Component)this.statusPanel, "North");
        this.add((Component)this.ugr, "Center");
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new FlowLayout());
        this.controlPanel.add(this.steinerModeButton);
        this.add((Component)this.controlPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public void setCostDisplay() {
        this.halfPerimDisplay.setValue(this.gr.halfPerim());
        this.lengthDisplay.setValue(this.gr.edgeLength());
        if (this.steinerMode) {
            this.improveDisplay.setValue((double)this.rmstLength / (double)this.gr.edgeLength());
        } else {
            this.improveDisplay.setValue(1.0);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.setCostDisplay();
    }

    public void initRandom() {
        int n = this.ugr.getWidth();
        int n2 = this.ugr.getHeight();
        this.gr.clearGraph();
        this.gr.addRandomNodes(10, n, n2);
        try {
            this.prim.primMST(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
    }

    public void readGraph(BufferedReader bufferedReader) throws IOException {
        this.gr.readGraph(bufferedReader);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "STMODE") {
            if (this.steinerModeButton.isSelected()) {
                this.steinerMode = true;
                this.steinerModeButton.setToolTipText("Editing Steiner Points - Click to Edit Terminals");
                this.ugr.setHananMode(true);
                this.ugr.selectNode(null);
                try {
                    this.prim.primMST(false);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.rmstLength = this.gr.edgeLength();
                this.repaint();
            } else {
                this.steinerMode = false;
                this.steinerModeButton.setToolTipText("Editing Terminals - Click to Edit Steiner Points");
                this.ugr.setHananMode(false);
                this.gr.removeNonTerminalNodes();
                try {
                    this.prim.primMST(false);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.repaint();
            }
        }
    }

    public void graphChanged() {
        try {
            this.prim.primMST(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        UISteinerDemo uISteinerDemo = new UISteinerDemo();
        jFrame.setSize(400, 400);
        jFrame.getContentPane().add(uISteinerDemo);
        jFrame.setVisible(true);
    }
}

