/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class GridPoint
implements Comparable {
    private static final int ROUTED = -2;
    private static final int OBSTACLE = -1;
    private static final int UNROUTED = 9999;
    private int posx;
    private int posy;
    private int posz;
    private boolean highlighted = false;
    private boolean enqueued = false;
    private int gVal = 9999;
    private int fVal = 0;
    private int qVal = 0;
    private Color routedColor = null;
    static Grid myGrid;
    private static ColorSequencer cseq;

    public GridPoint(int n, int n2, int n3) {
        this.posx = n;
        this.posy = n2;
        this.posz = n3;
    }

    public GridPoint(int n, int n2) {
        this(n, n2, 0);
    }

    public GridPoint northNeighbor() {
        return myGrid.gridPointAt(this.posx, this.posy - 1, this.posz);
    }

    public GridPoint southNeighbor() {
        return myGrid.gridPointAt(this.posx, this.posy + 1, this.posz);
    }

    public GridPoint eastNeighbor() {
        return myGrid.gridPointAt(this.posx + 1, this.posy, this.posz);
    }

    public GridPoint westNeighbor() {
        return myGrid.gridPointAt(this.posx - 1, this.posy, this.posz);
    }

    public GridPoint upNeighbor() {
        return myGrid.gridPointAt(this.posx, this.posy, this.posz - 1);
    }

    public GridPoint downNeighbor() {
        return myGrid.gridPointAt(this.posx, this.posy, this.posz + 1);
    }

    public int expand() throws InterruptedException {
        GridPoint gridPoint = this.westNeighbor();
        if (gridPoint != null && gridPoint.gVal == 9999) {
            gridPoint.setVals(this.fVal + this.detourNumber(gridPoint), this.gVal + 1);
            if (gridPoint.isTarget()) {
                return gridPoint.gVal;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.eastNeighbor()) != null && gridPoint.gVal == 9999) {
            gridPoint.setVals(this.fVal + this.detourNumber(gridPoint), this.gVal + 1);
            if (gridPoint.isTarget()) {
                return gridPoint.gVal;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.southNeighbor()) != null && gridPoint.gVal == 9999) {
            gridPoint.setVals(this.fVal + this.detourNumber(gridPoint), this.gVal + 1);
            if (gridPoint.isTarget()) {
                return gridPoint.gVal;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.northNeighbor()) != null && gridPoint.gVal == 9999) {
            gridPoint.setVals(this.fVal + this.detourNumber(gridPoint), this.gVal + 1);
            if (gridPoint.isTarget()) {
                return gridPoint.gVal;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.upNeighbor()) != null && gridPoint.gVal == 9999) {
            gridPoint.setVals(this.fVal + this.detourNumber(gridPoint), this.gVal + 1);
            if (gridPoint.isTarget()) {
                return gridPoint.gVal;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.downNeighbor()) != null && gridPoint.gVal == 9999) {
            gridPoint.setVals(this.fVal + this.detourNumber(gridPoint), this.gVal + 1);
            if (gridPoint.isTarget()) {
                return gridPoint.gVal;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        return -1;
    }

    public boolean isTarget() {
        return this == myGrid.getTarget();
    }

    public boolean isSource() {
        return this == myGrid.getSource();
    }

    public boolean isEmpty() {
        return this.gVal == 9999;
    }

    public void paintGridPoint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawRect(myGrid.gridPanelX(this.posx, this.posy, this.posz), myGrid.gridPanelY(this.posx, this.posy, this.posz), 19, 19);
        if (this.isRouted()) {
            graphics.setColor(this.routedColor);
            this.fillGridPoint(graphics);
        } else if (this.isObstacle()) {
            graphics.setColor(Color.red);
            this.fillGridPoint(graphics);
        } else if (this.isSource()) {
            if (this.highlighted) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.red);
            }
            this.fillGridPoint(graphics);
            graphics.setColor(Color.black);
            this.labelGridPoint(graphics, "S");
        } else if (this.isTarget()) {
            if (this.highlighted) {
                graphics.setColor(Color.yellow);
                this.fillGridPoint(graphics);
                graphics.setColor(Color.black);
                this.labelGridPoint(graphics, Integer.toString(this.gVal % 10));
            } else {
                graphics.setColor(Color.red);
                this.fillGridPoint(graphics);
                graphics.setColor(Color.black);
                this.labelGridPoint(graphics, "T");
            }
        } else if (this.gVal < 9999) {
            if (this.isEnqueued()) {
                graphics.setColor(Color.orange);
            } else {
                graphics.setColor(Color.yellow);
            }
            this.fillGridPoint(graphics);
            graphics.setColor(Color.black);
            this.labelGridPoint(graphics, Integer.toString(this.fVal % 10));
        }
    }

    private void fillGridPoint(Graphics graphics) {
        graphics.fillRect(myGrid.gridPanelX(this.posx, this.posy, this.posz) + 2, myGrid.gridPanelY(this.posx, this.posy, this.posz) + 2, 19 - 3, 19 - 3);
    }

    private void labelGridPoint(Graphics graphics, String string) {
        graphics.drawString(string, myGrid.gridPanelX(this.posx, this.posy, this.posz) + 6, myGrid.gridPanelY(this.posx, this.posy, this.posz) + 14);
    }

    public String toString() {
        return "GridPoint(" + this.posx + "," + this.posy + "," + this.posz + ")[f =" + this.fVal + " g=" + this.gVal + "] q=" + this.qVal;
    }

    public void reset() {
        this.fVal = 0;
        this.gVal = 9999;
    }

    public void initExpand() {
        this.gVal = 0;
    }

    public void setRouted() {
        this.gVal = -2;
        this.routedColor = cseq.current();
    }

    public boolean isRouted() {
        return this.gVal == -2;
    }

    public void setObstacle() {
        this.gVal = -1;
    }

    public boolean isObstacle() {
        return this.gVal == -2 || this.gVal == -1;
    }

    public boolean lessThan(GridPoint gridPoint) {
        return this.gVal != 0 && this.gVal < gridPoint.gVal;
    }

    public int manhattanDistance(GridPoint gridPoint) {
        return Math.abs(gridPoint.posx - this.posx) + Math.abs(gridPoint.posy - this.posy) + Math.abs(gridPoint.posz - this.posz);
    }

    public int detourNumber(GridPoint gridPoint) {
        GridPoint gridPoint2 = myGrid.getTarget();
        int n = this.manhattanDistance(gridPoint2);
        int n2 = gridPoint.manhattanDistance(gridPoint2);
        if (n2 > n) {
            return n2 - n;
        }
        return 0;
    }

    boolean isEnqueued() {
        return this.enqueued;
    }

    void setEnqueued(boolean bl) {
        this.enqueued = bl;
    }

    public void setQVal(int n) {
        this.qVal = n;
    }

    public int getFVal() {
        return this.fVal;
    }

    public int getGVal() {
        return this.gVal;
    }

    public void setVals(int n, int n2) {
        this.fVal = n;
        this.gVal = n2;
    }

    public void highlight(boolean bl) {
        this.highlighted = bl;
    }

    public static void nextRouteColor() {
        cseq.next();
    }

    public int compareTo(Object object) {
        GridPoint gridPoint = (GridPoint)object;
        if (this == gridPoint) {
            return 0;
        }
        if (this.fVal < gridPoint.fVal) {
            return -1;
        }
        if (this.fVal > gridPoint.fVal) {
            return 1;
        }
        if (this.qVal > gridPoint.qVal) {
            return -1;
        }
        if (this.qVal < gridPoint.qVal) {
            return 1;
        }
        if (this.hashCode() > gridPoint.hashCode()) {
            return -1;
        }
        return 1;
    }

    static {
        cseq = new ColorSequencer();
    }
}

