/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class Grid
extends Panel {
    private String msg = null;
    private boolean displayParallelMode = false;
    Image myOffScreenImage = null;
    Graphics myOffScreenGraphics = null;
    private GridLink gridPointHead;
    private GridLink gridPointTail;
    private static final int DELAY = 100;
    static final int GRIDSIZE = 19;
    static final int CHARXOFFSET = 6;
    static final int CHARYOFFSET = 14;
    private GridPoint clickedPoint = null;
    private boolean clearPending = false;
    private static final int WAITFORSRC = 0;
    private static final int WAITFORTGT = 1;
    GridPoint[][][] gridArray;
    GridPoint src;
    GridPoint tgt;

    public void setParallelExpand() {
        this.displayParallelMode = true;
    }

    public void setSerialExpand() {
        this.displayParallelMode = false;
    }

    public Grid(int n, int n2, int n3) {
        this.gridArray = new GridPoint[n][n2][n3];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n3) {
                    this.gridArray[n4][n5][n6] = new GridPoint(n4, n5, n6);
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        GridPoint.myGrid = this;
        this.setSize(this.pixelWidth(), this.pixelHeight());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Grid.this.handleMouseClick(mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public void setMessage(String string) {
        this.msg = string;
        this.redrawGrid();
    }

    public void flash(GridPoint gridPoint) throws InterruptedException {
        int n = 0;
        while (n < 3) {
            gridPoint.highlight(true);
            this.redrawGrid();
            Grid.gridDelay(4);
            gridPoint.highlight(false);
            this.redrawGrid();
            Grid.gridDelay(4);
            ++n;
        }
    }

    public void redrawGrid() {
        if (this.myOffScreenImage == null) {
            this.myOffScreenImage = this.createImage(this.getSize().width, this.getSize().height);
            this.myOffScreenGraphics = this.myOffScreenImage.getGraphics();
        }
        this.repaint();
    }

    public int width() {
        return this.gridArray.length;
    }

    public int height() {
        return this.gridArray[0].length;
    }

    public int depth() {
        return this.gridArray[0][0].length;
    }

    public int pixelWidth() {
        return this.width() * 19;
    }

    public int pixelHeight() {
        return this.depth() * (this.height() + 1) * 19;
    }

    public static int calculateCols(int n) {
        return (n - 2) / 19;
    }

    public static int calculateRows(int n, int n2) {
        int n3 = (n - 30) / 19 - 2;
        return n3 / n2 - 1;
    }

    public GridPoint gridPointAt(int n, int n2, int n3) {
        if (n < 0 || n >= this.width()) {
            return null;
        }
        if (n2 < 0 || n2 >= this.height()) {
            return null;
        }
        if (n3 < 0 || n3 >= this.depth()) {
            return null;
        }
        return this.gridArray[n][n2][n3];
    }

    public void reset() {
        int n = 0;
        while (n < this.width()) {
            int n2 = 0;
            while (n2 < this.height()) {
                int n3 = 0;
                while (n3 < this.depth()) {
                    GridPoint gridPoint = this.gridPointAt(n, n2, n3);
                    if (!gridPoint.isObstacle()) {
                        gridPoint.reset();
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.width()) {
            int n2 = 0;
            while (n2 < this.height()) {
                int n3 = 0;
                while (n3 < this.depth()) {
                    GridPoint gridPoint = this.gridPointAt(n, n2, n3);
                    gridPoint.reset();
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    void printGridPointQueue() {
        GridLink gridLink = this.gridPointHead;
        while (gridLink != null) {
            System.out.print(gridLink.wot + " ");
            gridLink = gridLink.next;
        }
        System.out.println();
    }

    public void enqueueGridPoint(GridPoint gridPoint) throws InterruptedException {
        if (this.gridPointHead == null) {
            this.gridPointHead = this.gridPointTail = new GridLink(gridPoint);
        } else {
            GridLink gridLink = new GridLink(gridPoint);
            this.gridPointTail.next = gridLink;
            this.gridPointTail = gridLink;
        }
        gridPoint.setEnqueued(true);
        if (!this.displayParallelMode) {
            this.redrawGrid();
            Grid.gridDelay();
        }
    }

    public GridPoint dequeueGridPoint() {
        if (this.gridPointHead == null) {
            return null;
        }
        GridPoint gridPoint = this.gridPointHead.wot;
        this.gridPointHead = this.gridPointHead.next;
        gridPoint.setEnqueued(false);
        return gridPoint;
    }

    public void clearQueue() {
        this.gridPointHead = null;
    }

    public static void gridDelay(int n) throws InterruptedException {
        Thread.sleep(n * 100);
    }

    public static void gridDelay() throws InterruptedException {
        Grid.gridDelay(1);
    }

    /*
     * Unable to fully structure code
     */
    public int expansion() throws InterruptedException {
        block2: {
            var3_1 = 0;
            this.setMessage("Expansion phase");
            Grid.gridDelay(3);
            if (this.src == null || this.tgt == null) break block2;
            this.src.initExpand();
            var2_2 = this.src.expand();
            if (var2_2 <= 0) ** GOTO lbl17
            this.clearQueue();
            return var2_2;
lbl-1000:
            // 1 sources

            {
                if (this.displayParallelMode && var1_3.getVal() > var3_1) {
                    var3_1 = var1_3.getVal();
                    this.redrawGrid();
                    Grid.gridDelay(2);
                }
                if ((var2_2 = var1_3.expand()) <= 0) continue;
                this.clearQueue();
                return var2_2;
lbl17:
                // 2 sources

                ** while ((var1_3 = this.dequeueGridPoint()) != null)
            }
        }
        return -1;
    }

    public void traceBack() throws InterruptedException {
        GridPoint gridPoint = this.tgt;
        while (!gridPoint.isSource()) {
            int n = gridPoint.getVal();
            this.setMessage("Traceback: distance = " + n);
            gridPoint.setRouted();
            this.redrawGrid();
            Grid.gridDelay(3);
            GridPoint gridPoint2 = gridPoint.westNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.eastNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.southNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.northNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.upNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.downNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            System.out.println("AWK! can't trace back! current= " + gridPoint);
            break;
        }
        if (gridPoint.isSource()) {
            this.setMessage("Traceback complete");
            this.flash(gridPoint);
            gridPoint.setRouted();
        } else {
            System.out.println("Warning: traceBack failed!");
        }
    }

    int gridPanelX(int n, int n2, int n3) {
        return n * 19;
    }

    int gridPanelY(int n, int n2, int n3) {
        return n3 * (19 * (this.height() + 1)) + (n2 + 1) * 19;
    }

    int gridLyrY(int n) {
        return 19 * n * (this.height() + 1) + 14;
    }

    int gridMsgY() {
        return 19 * this.depth() * (this.height() + 1) + 14;
    }

    public synchronized void handleMouseClick(int n, int n2) {
        this.clickedPoint = this.mouseToGridPoint(n, n2);
        this.notifyAll();
    }

    public synchronized void requestClear() {
        this.clearPending = true;
        this.notifyAll();
    }

    GridPoint mouseToGridPoint(int n, int n2) {
        int n3 = n / 19;
        int n4 = 0;
        while (n4 < this.depth()) {
            if (n2 >= this.gridPanelY(0, 0, n4) && n2 <= this.gridPanelY(0, 0, n4 + 1) - 19) {
                int n5 = n2 % ((this.height() + 1) * 19) / 19 - 1;
                if (n3 >= 0 && n3 < this.width() && n5 >= 0 && n5 < this.height() && n4 >= 0 && n4 < this.depth()) {
                    return this.gridPointAt(n3, n5, n4);
                }
                return null;
            }
            ++n4;
        }
        return null;
    }

    private synchronized void waitForInput() throws InterruptedException {
        while (!this.clearPending && this.clickedPoint == null) {
            this.wait();
        }
    }

    public void run() throws InterruptedException {
        this.clear();
        boolean bl = false;
        this.setMessage("Click on Source");
        while (true) {
            this.waitForInput();
            if (!bl) {
                if (this.clearPending) {
                    this.clear();
                    this.setMessage("Grid cleared!");
                    Grid.gridDelay(5);
                    this.setMessage("Click on Source");
                    this.clearPending = false;
                    continue;
                }
                if (this.clickedPoint == null) continue;
                if (!this.clickedPoint.isRouted()) {
                    this.setSource(this.clickedPoint);
                    System.out.println("Setting source: " + this.clickedPoint);
                    bl = true;
                    this.setMessage("Click on Target");
                } else {
                    this.setMessage("Already routed!");
                    Grid.gridDelay(5);
                    this.setMessage("Click on Source");
                }
                this.clickedPoint = null;
                continue;
            }
            if (!bl) continue;
            if (this.clickedPoint != null) {
                this.setTarget(this.clickedPoint);
                System.out.println("Setting target: " + this.clickedPoint);
                this.clickedPoint = null;
                this.setMessage("Ready to Route!");
                Grid.gridDelay(5);
                this.redrawGrid();
                this.route();
                this.src = null;
                this.tgt = null;
                bl = false;
                this.setMessage("Click on Source");
                this.redrawGrid();
            }
            this.clearPending = false;
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        int n = 0;
        while (n < this.depth()) {
            graphics.setColor(Color.black);
            graphics.drawString("Layer " + (n + 1), 6, this.gridLyrY(n));
            int n2 = 0;
            while (n2 < this.height()) {
                int n3 = 0;
                while (n3 < this.width()) {
                    this.gridArray[n3][n2][n].paintGridPoint(graphics);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        if (this.msg != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this.msg, 6, this.gridMsgY());
        }
    }

    public void update(Graphics graphics) {
        this.paint(this.myOffScreenGraphics);
        graphics.drawImage(this.myOffScreenImage, 0, 0, this);
    }

    public void setSource(int n, int n2, int n3) {
        this.setSource(this.gridArray[n][n2][n3]);
    }

    public void setSource(GridPoint gridPoint) {
        this.src = gridPoint;
    }

    public void setTarget(int n, int n2, int n3) {
        this.tgt = this.gridArray[n][n2][n3];
    }

    public void setTarget(GridPoint gridPoint) {
        this.tgt = gridPoint;
    }

    public GridPoint getSource() {
        return this.src;
    }

    public GridPoint getTarget() {
        return this.tgt;
    }

    public int route() throws InterruptedException {
        if (this.src == null || this.tgt == null) {
            return -1;
        }
        GridPoint.nextRouteColor();
        this.reset();
        if (this.src == this.tgt) {
            this.src.setRouted();
            return 0;
        }
        int n = this.expansion();
        this.clearQueue();
        this.redrawGrid();
        if (n > 0) {
            this.setMessage("Target Found!");
            this.flash(this.tgt);
            this.traceBack();
        } else {
            this.setMessage("Target not found!");
        }
        this.reset();
        this.redrawGrid();
        return n;
    }

    public int route(GridPoint gridPoint, GridPoint gridPoint2) throws InterruptedException {
        this.setSource(gridPoint);
        this.setTarget(gridPoint2);
        return this.route();
    }

    public int route(int n, int n2, int n3, int n4, int n5, int n6) throws InterruptedException {
        return this.route(this.gridPointAt(n, n2, n3), this.gridPointAt(n4, n5, n6));
    }

    private class GridLink {
        private GridLink next;
        private GridPoint wot;

        public GridLink(GridPoint gridPoint) {
            this.wot = gridPoint;
            this.next = null;
        }
    }
}

