/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class GridPoint {
    private static final int ROUTED = -2;
    private static final int OBSTACLE = -1;
    private static final int UNROUTED = 9999;
    private int posx;
    private int posy;
    private int posz;
    private boolean highlighted = false;
    private boolean enqueued = false;
    private int val = 9999;
    private Color routedColor = null;
    static Grid myGrid;
    private static ColorSequencer cseq;

    public GridPoint(int n, int n2, int n3) {
        this.posx = n;
        this.posy = n2;
        this.posz = n3;
    }

    public GridPoint(int n, int n2) {
        this(n, n2, 0);
    }

    public GridPoint northNeighbor() {
        return myGrid.gridPointAt(this.posx, this.posy - 1, this.posz);
    }

    public GridPoint southNeighbor() {
        return myGrid.gridPointAt(this.posx, this.posy + 1, this.posz);
    }

    public GridPoint eastNeighbor() {
        return myGrid.gridPointAt(this.posx + 1, this.posy, this.posz);
    }

    public GridPoint westNeighbor() {
        return myGrid.gridPointAt(this.posx - 1, this.posy, this.posz);
    }

    public GridPoint upNeighbor() {
        return myGrid.gridPointAt(this.posx, this.posy, this.posz - 1);
    }

    public GridPoint downNeighbor() {
        return myGrid.gridPointAt(this.posx, this.posy, this.posz + 1);
    }

    public int expand() throws InterruptedException {
        GridPoint gridPoint = this.westNeighbor();
        if (gridPoint != null && gridPoint.val == 9999) {
            gridPoint.val = this.val + 1;
            if (gridPoint.isTarget()) {
                return gridPoint.val;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.eastNeighbor()) != null && gridPoint.val == 9999) {
            gridPoint.val = this.val + 1;
            if (gridPoint.isTarget()) {
                return gridPoint.val;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.southNeighbor()) != null && gridPoint.val == 9999) {
            gridPoint.val = this.val + 1;
            if (gridPoint.isTarget()) {
                return gridPoint.val;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.northNeighbor()) != null && gridPoint.val == 9999) {
            gridPoint.val = this.val + 1;
            if (gridPoint.isTarget()) {
                return gridPoint.val;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.upNeighbor()) != null && gridPoint.val == 9999) {
            gridPoint.val = this.val + 1;
            if (gridPoint.isTarget()) {
                return gridPoint.val;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        if ((gridPoint = this.downNeighbor()) != null && gridPoint.val == 9999) {
            gridPoint.val = this.val + 1;
            if (gridPoint.isTarget()) {
                return gridPoint.val;
            }
            myGrid.enqueueGridPoint(gridPoint);
        }
        return -1;
    }

    public boolean isTarget() {
        return this == myGrid.getTarget();
    }

    public boolean isSource() {
        return this == myGrid.getSource();
    }

    public boolean isEmpty() {
        return this.val == 9999;
    }

    public void paintGridPoint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawRect(myGrid.gridPanelX(this.posx, this.posy, this.posz), myGrid.gridPanelY(this.posx, this.posy, this.posz), 19, 19);
        if (this.isRouted()) {
            graphics.setColor(this.routedColor);
            this.fillGridPoint(graphics);
        } else if (this.isObstacle()) {
            graphics.setColor(Color.red);
            this.fillGridPoint(graphics);
        } else if (this.isSource()) {
            if (this.highlighted) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.red);
            }
            this.fillGridPoint(graphics);
            graphics.setColor(Color.black);
            this.labelGridPoint(graphics, "S");
        } else if (this.isTarget()) {
            if (this.highlighted) {
                graphics.setColor(Color.yellow);
                this.fillGridPoint(graphics);
                graphics.setColor(Color.black);
                this.labelGridPoint(graphics, Integer.toString(this.val % 10));
            } else {
                graphics.setColor(Color.red);
                this.fillGridPoint(graphics);
                graphics.setColor(Color.black);
                this.labelGridPoint(graphics, "T");
            }
        } else if (this.val < 9999) {
            if (this.isEnqueued()) {
                graphics.setColor(Color.orange);
            } else {
                graphics.setColor(Color.yellow);
            }
            this.fillGridPoint(graphics);
            graphics.setColor(Color.black);
            this.labelGridPoint(graphics, Integer.toString(this.val % 10));
        }
    }

    private void fillGridPoint(Graphics graphics) {
        graphics.fillRect(myGrid.gridPanelX(this.posx, this.posy, this.posz) + 2, myGrid.gridPanelY(this.posx, this.posy, this.posz) + 2, 19 - 3, 19 - 3);
    }

    private void labelGridPoint(Graphics graphics, String string) {
        graphics.drawString(string, myGrid.gridPanelX(this.posx, this.posy, this.posz) + 6, myGrid.gridPanelY(this.posx, this.posy, this.posz) + 14);
    }

    public String toString() {
        return "GridPoint(" + this.posx + "," + this.posy + "," + this.posz + ")[" + this.val + "]";
    }

    public void reset() {
        this.val = 9999;
    }

    public void initExpand() {
        this.val = 0;
    }

    public void setRouted() {
        this.val = -2;
        this.routedColor = cseq.current();
    }

    public boolean isRouted() {
        return this.val == -2;
    }

    public void setObstacle() {
        this.val = -1;
    }

    public boolean isObstacle() {
        return this.val == -2 || this.val == -1;
    }

    public boolean lessThan(GridPoint gridPoint) {
        return this.val != 0 && this.val < gridPoint.val;
    }

    public int manhattanDistance(GridPoint gridPoint) {
        return Math.abs(gridPoint.posx - this.posx) + Math.abs(gridPoint.posy - this.posy) + Math.abs(gridPoint.posz - this.posz);
    }

    boolean isEnqueued() {
        return this.enqueued;
    }

    void setEnqueued(boolean bl) {
        this.enqueued = bl;
    }

    public int getVal() {
        return this.val;
    }

    public void highlight(boolean bl) {
        this.highlighted = bl;
    }

    public static void nextRouteColor() {
        cseq.next();
    }

    static {
        cseq = new ColorSequencer();
    }
}

