/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public class ChannelRouterApplet
extends Applet {
    private TextField[] upperFields;
    private TextField[] lowerFields;
    private Netlist n;
    ChannelRouterCanvas cv;

    public void init() {
        System.out.println("starting applet!!!");
        this.n = new Netlist();
        this.setLayout(new BorderLayout());
        Panel up = new Panel();
        Panel lp = new Panel();
        Panel gp = new Panel();
        Panel bp = new Panel();
        this.cv = new ChannelRouterCanvas(this.n);
        this.setLayout(new BorderLayout());
        up.setLayout(new GridLayout(1, 10));
        lp.setLayout(new GridLayout(1, 10));
        gp.setLayout(new BorderLayout());
        bp.setLayout(new FlowLayout());
        Button cb = new Button("Clear Nets");
        Button rb = new Button("Route Nets");
        this.upperFields = new TextField[10];
        this.lowerFields = new TextField[10];
        int i = 0;
        while (i < 10) {
            TextField tf;
            this.upperFields[i] = tf = new TextField("", 2);
            up.add(tf);
            this.lowerFields[i] = tf = new TextField("", 2);
            lp.add("Center", tf);
            ++i;
        }
        gp.add("North", up);
        gp.add("South", lp);
        gp.add("Center", this.cv);
        bp.add(cb);
        bp.add(rb);
        this.add("South", bp);
        this.add("Center", gp);
    }

    private void clearNetFields() {
        int i = 0;
        while (i < 10) {
            ((TextComponent)this.upperFields[i]).setText("");
            ((TextComponent)this.lowerFields[i]).setText("");
            ++i;
        }
    }

    private void scanFieldsAndRoute() {
        this.n.clear();
        int i = 0;
        while (i < 10) {
            Terminal term;
            Net nt;
            String uname = this.upperFields[i].getText().trim();
            String lname = this.lowerFields[i].getText().trim();
            if (!uname.equals("")) {
                nt = this.n.findNet(uname);
                if (nt == null) {
                    nt = new Net(uname);
                    this.n.addNet(nt);
                }
                term = this.n.getTerminal(i, true);
                nt.addTerminal(term);
            }
            if (!lname.equals("")) {
                nt = this.n.findNet(lname);
                if (nt == null) {
                    nt = new Net(lname);
                    this.n.addNet(nt);
                }
                term = this.n.getTerminal(i, false);
                nt.addTerminal(term);
            }
            ++i;
        }
        this.n.leftEdgeAlgorithm();
    }

    public boolean handleEvent(Event evt) {
        if (evt.id == 201) {
            System.exit(0);
        }
        return super.handleEvent(evt);
    }

    public boolean action(Event evt, Object arg) {
        if (arg.equals("Route Nets")) {
            this.scanFieldsAndRoute();
            this.cv.repaint();
        } else if (arg.equals("Clear Nets")) {
            this.clearNetFields();
            this.scanFieldsAndRoute();
            this.cv.repaint();
        } else {
            return super.action(evt, arg);
        }
        return true;
    }
}

