/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;

class ChannelRouterCanvas
extends Canvas {
    private Netlist nl;
    private static final int BORDER_Y_OFFSET = 10;
    private static final int HEIGHT_ADJUST = 10;
    private static final int WIDTH_ADJUST = 1;
    private int colWidth;
    private int trackHeight;
    private Font f;
    private FontMetrics fm;
    private boolean fontsSet = false;

    public ChannelRouterCanvas(Netlist n) {
        this.nl = n;
    }

    private void setScale() {
        Dimension d = this.size();
        this.colWidth = d.width / 10;
        this.trackHeight = (d.height - 10 - 10) / (this.nl.getMaxTrack() + 1);
    }

    public int trackY(int track) {
        return 10 + this.trackHeight * track;
    }

    public int colX(int col) {
        return this.colWidth / 2 + this.colWidth * col;
    }

    public int channelWidth() {
        return this.colWidth * 10 - 1;
    }

    public int channelHeight() {
        return this.trackY(this.nl.getMaxTrack() + 1) - this.trackY(0) + 1;
    }

    private void setFonts(Graphics g) {
        if (this.fontsSet) {
            return;
        }
        this.f = new Font("Helvetica", 0, 12);
        this.fm = g.getFontMetrics(this.f);
        g.setFont(this.f);
        this.fontsSet = true;
    }

    public void paint(Graphics g) {
        this.setFonts(g);
        this.setScale();
        g.drawRect(0, 10, this.channelWidth(), this.channelHeight());
        if (this.nl.getCyclesPresent()) {
            g.drawString("This circuit contains unresolved vertical constraint cycles", 20, this.trackY(1) - 5);
        }
        Enumeration e = this.nl.getNets();
        while (e.hasMoreElements()) {
            Net n = (Net)e.nextElement();
            if (n.getTrack() == 0) continue;
            g.setColor(Color.blue);
            g.fillRect(this.colX(n.getLeftEdge()), this.trackY(n.getTrack()) - 2, this.colX(n.getRightEdge()) - this.colX(n.getLeftEdge()) + 2, 5);
            Enumeration eterms = n.getTerminals();
            while (eterms.hasMoreElements()) {
                Terminal t = (Terminal)eterms.nextElement();
                g.setColor(Color.red);
                if (t.getTopOrBottom()) {
                    g.fillRect(this.colX(t.getColumn()) - 2, this.trackY(0), 5, this.trackY(n.getTrack()) - this.trackY(0) + 3);
                } else {
                    g.fillRect(this.colX(t.getColumn()) - 2, this.trackY(n.getTrack()) - 2, 5, this.trackY(this.nl.getMaxTrack() + 1) - this.trackY(n.getTrack()) + 4);
                }
                g.setColor(Color.black);
                g.fillRect(this.colX(t.getColumn()) - 3, this.trackY(n.getTrack()) - 3, 7, 7);
            }
        }
    }
}

