/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

class Net {
    public static final int TRACK_UNASSIGNED = 0;
    private String name;
    private Vector terms = new Vector(5);
    private Vector constraints = new Vector(2);
    private int leftEdge = Integer.MAX_VALUE;
    private int rightEdge = 0;
    private int track = 0;
    private boolean mark = false;

    public Net(String n) {
        this.name = n;
    }

    public boolean isRouted() {
        return this.getTrack() != 0;
    }

    public int getTrack() {
        return this.track;
    }

    public void setTrack(int t) {
        this.track = t;
    }

    public int getLeftEdge() {
        return this.leftEdge;
    }

    public int getRightEdge() {
        return this.rightEdge;
    }

    public boolean overlap(Net n2) {
        int l1 = this.getLeftEdge();
        int r1 = this.getRightEdge();
        int l2 = n2.getLeftEdge();
        int r2 = n2.getRightEdge();
        return l2 <= r1 && r2 >= l1 || l1 <= r2 && r1 >= l2;
    }

    public void writeNet(PrintStream os) {
        os.print(String.valueOf(this.name) + " ");
        if (this.getTrack() != 0) {
            os.print(String.valueOf(this.track) + " ");
        }
        Enumeration e = this.terms.elements();
        while (e.hasMoreElements()) {
            ((Terminal)e.nextElement()).writeTerminal(os);
        }
        os.println();
    }

    public String getName() {
        return this.name;
    }

    public void addTerminal(Terminal trm) {
        this.terms.addElement(trm);
        trm.setNet(this);
        if (trm.getColumn() < this.leftEdge) {
            this.leftEdge = trm.getColumn();
        }
        if (trm.getColumn() > this.rightEdge) {
            this.rightEdge = trm.getColumn();
        }
    }

    public Enumeration getTerminals() {
        return this.terms.elements();
    }

    public void addConstraint(Net nt) {
        if (!this.constraints.contains(nt)) {
            this.constraints.addElement(nt);
        }
    }

    public boolean checkConstraint() {
        if (this.constraints == null) {
            return true;
        }
        boolean result = true;
        this.setMark(true);
        int i = 0;
        while (i < this.constraints.size()) {
            Net ctgt = (Net)this.constraints.elementAt(i);
            if (ctgt.getMark()) {
                this.constraints.removeElementAt(i);
                result = false;
            } else if (!ctgt.checkConstraint()) {
                result = false;
            }
            ++i;
        }
        this.setMark(false);
        return result;
    }

    public Enumeration getConstraints() {
        return this.constraints.elements();
    }

    public boolean testConstraints() {
        Enumeration e = this.getConstraints();
        while (e.hasMoreElements()) {
            Net testnet = (Net)e.nextElement();
            if (testnet.isRouted()) continue;
            return false;
        }
        return true;
    }

    public void setMark(boolean m) {
        this.mark = m;
    }

    public boolean getMark() {
        return this.mark;
    }
}

