/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

class Netlist {
    private Terminal[] upperTerms;
    private Terminal[] lowerTerms;
    private Vector nlist = new Vector();
    private int maxTrack = 0;
    private boolean cyclesPresent = false;
    public static final int NUM_COLS = 10;

    public Netlist() {
        this.upperTerms = new Terminal[10];
        this.lowerTerms = new Terminal[10];
        int i = 0;
        while (i < 10) {
            this.upperTerms[i] = new Terminal(i, true);
            this.lowerTerms[i] = new Terminal(i, false);
            ++i;
        }
    }

    public boolean getCyclesPresent() {
        return this.cyclesPresent;
    }

    public Terminal getTerminal(int pos, boolean topOrBottom) {
        if (topOrBottom) {
            return this.upperTerms[pos];
        }
        return this.lowerTerms[pos];
    }

    public void addNet(Net n) {
        int i = 0;
        while (i < this.nlist.size()) {
            if (((Net)this.nlist.elementAt(i)).getLeftEdge() > n.getLeftEdge()) {
                this.nlist.insertElementAt(n, i);
                return;
            }
            ++i;
        }
        this.nlist.addElement(n);
    }

    void unmarkNets() {
        Enumeration e = this.getNets();
        while (e.hasMoreElements()) {
            ((Net)e.nextElement()).setMark(false);
        }
    }

    public void makeConstraints() {
        Net lnet;
        int i = 0;
        while (i < 10) {
            Net unet = this.upperTerms[i].getNet();
            lnet = this.lowerTerms[i].getNet();
            if (unet != null && lnet != null && unet != lnet) {
                lnet.addConstraint(unet);
            }
            ++i;
        }
        this.cyclesPresent = false;
        int i2 = 0;
        while (i2 < 10) {
            this.unmarkNets();
            lnet = this.lowerTerms[i2].getNet();
            if (lnet != null && !lnet.checkConstraint()) {
                this.cyclesPresent = true;
            }
            ++i2;
        }
    }

    public void clear() {
        this.nlist.removeAllElements();
        int i = 0;
        while (i < 10) {
            this.upperTerms[i].setNet(null);
            this.lowerTerms[i].setNet(null);
            ++i;
        }
    }

    public Enumeration getNets() {
        return this.nlist.elements();
    }

    public Net findNet(String findName) {
        int i = 0;
        while (i < this.nlist.size()) {
            Net nt = (Net)this.nlist.elementAt(i);
            if (nt.getName().equals(findName)) {
                return nt;
            }
            ++i;
        }
        return null;
    }

    public void write(PrintStream os) {
        os.println("Writing netlist");
        Enumeration e = this.nlist.elements();
        while (e.hasMoreElements()) {
            ((Net)e.nextElement()).writeNet(os);
        }
    }

    private boolean canRoute(Net testNet, int trk) {
        Enumeration ne = this.nlist.elements();
        while (ne.hasMoreElements()) {
            Net n = (Net)ne.nextElement();
            if (n.getTrack() != trk || !testNet.overlap(n)) continue;
            return false;
        }
        return true;
    }

    public void leftEdgeAlgorithm() {
        this.makeConstraints();
        int track = 0;
        boolean done = false;
        while (!done) {
            ++track;
            done = true;
            Enumeration e = this.nlist.elements();
            while (e.hasMoreElements()) {
                Net n = (Net)e.nextElement();
                if (n.isRouted()) continue;
                if (n.testConstraints() && this.canRoute(n, track)) {
                    n.setTrack(track);
                    continue;
                }
                done = false;
            }
        }
        this.maxTrack = track;
    }

    public int getMaxTrack() {
        return this.maxTrack;
    }
}

