/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

class PTerminal {
    private String name;
    private PModule parent;
    private int xoff;
    private int yoff;
    private PNet tnet;

    public PTerminal(String string, PModule pModule, int n, int n2) {
        this.name = string;
        this.parent = pModule;
        this.xoff = n;
        this.yoff = n2;
    }

    public String getName() {
        return this.name;
    }

    public PModule getParent() {
        return this.parent;
    }

    public String toString() {
        return "PTerminal " + this.name + " module " + this.getParent().getName() + "(" + this.xoff + "," + this.yoff + ")";
    }

    void rotate() {
        int n = this.getParent().width() - this.yoff;
        this.yoff = this.xoff;
        this.xoff = n;
    }

    void flipVertical() {
        this.yoff = this.getParent().height() - this.yoff;
    }

    void flipHorizontal() {
        this.xoff = this.getParent().width() - this.xoff;
    }

    public int getX() {
        return this.xoff;
    }

    public int getY() {
        return this.yoff;
    }

    public int getLayoutX() {
        return this.parent.getX() + this.xoff;
    }

    public int getLayoutY() {
        return this.parent.getY() + this.yoff;
    }

    public void connectNet(PNet pNet) {
        this.tnet = pNet;
    }

    public void disconnectNet() {
        this.tnet = null;
    }

    public void paintTerminal(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(this.getX() - 2, this.getY() - 2, 5, 5);
    }

    public static PTerminal parseTerminal(StringTokenizer stringTokenizer, PLayout pLayout) {
        String string = stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        PModule pModule = pLayout.findModule(string2);
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        PTerminal pTerminal = new PTerminal(string, pModule, n, n2);
        pModule.addTerminal(pTerminal);
        return pTerminal;
    }
}

