/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DecimalField
extends JTextField {
    private NumberFormat format;

    public DecimalField(double value, int columns, NumberFormat f) {
        super(columns);
        ((JTextComponent)this).setDocument(new FormattedDocument(f));
        this.format = f;
        this.setValue(value);
    }

    public double getValue() {
        double retVal = 0.0;
        try {
            retVal = this.format.parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
            System.err.println("getValue: could not parse: ".concat(String.valueOf(String.valueOf(this.getText()))));
        }
        return retVal;
    }

    public void setValue(double value) {
        this.setText(this.format.format(value));
    }
}

