/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class DragListener
implements MouseListener,
MouseMotionListener {
    private int firstX = 0;
    private int firstY = 0;

    public void mouseClicked(MouseEvent e) {
        UIModule um = (UIModule)e.getComponent();
        if (e.isAltDown()) {
            um.flipVertical();
        } else if (e.isShiftDown()) {
            um.flipHorizontal();
        } else {
            um.rotate();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.firstX = e.getX();
        this.firstY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        this.firstX = 0;
        this.firstY = 0;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int dx = e.getX() - this.firstX;
        int dy = e.getY() - this.firstY;
        Component c = e.getComponent();
        Point loc = c.getLocation();
        loc.x += dx;
        loc.y += dy;
        c.setLocation(loc);
        c.getParent().getParent().repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }
}

