/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FormattedDocument
extends PlainDocument {
    private Format format;
    private ParsePosition parsePos = new ParsePosition(0);

    public FormattedDocument(Format f) {
        this.format = f;
    }

    public Format getFormat() {
        return this.format;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(beforeOffset))).append(str).append(afterOffset)));
        try {
            this.parsePos.setIndex(0);
            this.format.parseObject(proposedResult, this.parsePos);
            if (this.parsePos.getIndex() != proposedResult.length()) {
                throw new ParseException("Couldn't parse end of field", this.parsePos.getIndex());
            }
            super.insertString(offs, str, a);
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
            System.err.println("insertString: could not parse: ".concat(String.valueOf(String.valueOf(proposedResult))));
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(len + offs, currentText.length());
        String proposedResult = String.valueOf(String.valueOf(beforeOffset)).concat(String.valueOf(String.valueOf(afterOffset)));
        try {
            if (proposedResult.length() != 0) {
                this.format.parseObject(proposedResult);
            }
            super.remove(offs, len);
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
            System.err.println("remove: could not parse: ".concat(String.valueOf(String.valueOf(proposedResult))));
        }
    }
}

