/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class PAnnealer {
    private Vector tempHistory = new Vector(500);
    private UIAnnealer myUI;
    private PLayout myLayout;
    private double currentTemperature;
    private static final int SIGMA_MULTIPLIER = 20;

    public PAnnealer(PLayout pl) {
        this.myLayout = pl;
    }

    void setUIAnnealer(UIAnnealer u) {
        this.myUI = u;
    }

    public int numTemperatures() {
        return this.tempHistory.size();
    }

    public void addTempHistory(PTempHistory p) {
        this.tempHistory.addElement(p);
    }

    public PTempHistory getTempHistory(int i) {
        return (PTempHistory)this.tempHistory.elementAt(i);
    }

    public void applyMove() {
        this.myLayout.applyMove();
    }

    private double getT() {
        return this.currentTemperature;
    }

    private void setT(double temp) {
        this.currentTemperature = temp;
        PMove.setT(temp);
    }

    public void setT0(double temp) {
        this.currentTemperature = temp;
        PMove.setT0(temp);
    }

    public void findT0(boolean animate) throws InterruptedException {
        this.setT0(Double.POSITIVE_INFINITY);
        PTempHistory thisTemp = new PTempHistory(this.currentTemperature);
        this.metropolis(thisTemp, animate);
        double sigma = thisTemp.getStdev();
        this.setT0(sigma * (double)20);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("PAnnealer.findT0: sigma=").append(sigma).append(" T0=").append(this.currentTemperature))));
    }

    public boolean terminate(int percentImp, int lastN) {
        int numTemps = this.numTemperatures();
        if (numTemps < lastN) {
            return false;
        }
        double lastCost = this.getTempHistory(numTemps - 1).getMinCost();
        for (int i = numTemps - 2; i >= numTemps - lastN; --i) {
            double prevCost = this.getTempHistory(i).getMinCost();
            if (lastCost < prevCost && (int)((prevCost - lastCost) / prevCost * (double)100) > percentImp) {
                return false;
            }
            lastCost = prevCost;
        }
        return true;
    }

    public boolean terminate(int lastN) {
        int numTemps = this.numTemperatures();
        if (numTemps < lastN) {
            return false;
        }
        double lastCost = this.getTempHistory(numTemps - 1).getMinCost();
        for (int i = numTemps - 2; i >= numTemps - lastN; --i) {
            double prevCost = this.getTempHistory(i).getMinCost();
            if (lastCost == prevCost) continue;
            return false;
        }
        return true;
    }

    public boolean accept(double deltaCost) {
        if (deltaCost <= 0.0) {
            return true;
        }
        if (this.getT() == Double.POSITIVE_INFINITY) {
            return true;
        }
        return Math.random() < Math.exp(-deltaCost / this.getT());
    }

    public void metropolis(PTempHistory thisTemp, boolean animate) throws InterruptedException {
        PMove.setWindow(this.myLayout.currentWidth(), this.myLayout.currentHeight());
        int attemptsPerTemp = this.myUI.getOptMovesPerTemp();
        if (this.myUI.getOptMovesPerTempPerModule()) {
            attemptsPerTemp *= this.myLayout.numModules();
        }
        System.out.println("attemptsPerTemp = ".concat(String.valueOf(String.valueOf(attemptsPerTemp))));
        for (int i = 0; i < attemptsPerTemp; ++i) {
            int dc = this.myLayout.applyMove();
            this.myUI.setAnnealDisplay(thisTemp);
            if (animate) {
                this.myUI.animateStep();
            }
            if (this.accept(dc)) {
                thisTemp.addSample(this.myLayout.currentCost(), true);
                continue;
            }
            thisTemp.addSample(this.myLayout.currentCost(), false);
            this.myLayout.undoMove();
            this.myUI.setAnnealDisplay(thisTemp);
            if (!animate) continue;
            this.myUI.animateStep();
        }
    }

    public void anneal(boolean animate) throws InterruptedException {
        do {
            PTempHistory thisTemp = new PTempHistory(this.getT());
            this.addTempHistory(thisTemp);
            this.metropolis(thisTemp, animate);
            this.myUI.animateStep();
            this.setT(this.getT() * this.myUI.getOptCoolRate());
        } while (!this.terminate(3));
    }

    static {
        SIGMA_MULTIPLIER = 20;
    }
}

