/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class PLayout {
    private Vector modules = new Vector();
    private Vector nets = new Vector();
    private static final int NO_MOVE = 0;
    private static final int H_MOVE = 1;
    private static final int V_MOVE = 2;
    private static final int R_MOVE = 3;
    private PModule moveModule = null;
    private int moveApplied = 0;
    private int moveDistance = 0;
    private int curArea = 0;
    private int curRightEdge = 0;
    private int curLeftEdge = 0;
    private int curBottomEdge = 0;
    private int curTopEdge = 0;
    private int oldArea = 0;
    private int curOlap = 0;
    private int oldOlap = 0;
    private int curWirelength = 0;
    private int oldWirelength = 0;
    private int curCost = 0;
    private int oldCost = 0;
    private int moveLimit;
    private boolean verbose = false;
    private static final int K_OLAP = 5;
    private static final int K_NETLENGTH = 10;
    private PMove lastMove = null;

    public PLayout(String fname) {
        this.readLayout(fname);
        PModule.setLayout(this);
    }

    public PLayout(BufferedReader in) throws IOException {
        this.readLayout(in);
        PModule.setLayout(this);
    }

    public PMove getLastMove() {
        return this.lastMove;
    }

    public int applyMove() {
        this.lastMove = PMove.selectMove(this.selectModule());
        return this.lastMove.getDeltaCost();
    }

    public void undoMove() {
        this.lastMove.undo();
    }

    public int calcCost() {
        this.oldCost = this.curCost;
        this.oldOlap = this.curOlap;
        this.oldWirelength = this.curWirelength;
        this.curArea = this.calcArea();
        this.curOlap = this.calcOverlap();
        this.curWirelength = this.calcWirelength();
        this.curCost = this.curArea + 10 * this.curWirelength + 5 * this.curOlap * this.curOlap;
        return this.curCost;
    }

    public int getDeltaCost() {
        return this.curCost - this.oldCost;
    }

    public int undoUpdateCost() {
        this.curArea = this.oldArea;
        this.curOlap = this.oldOlap;
        this.curWirelength = this.oldWirelength;
        this.curCost = this.oldCost;
        return this.curCost;
    }

    public int currentCost() {
        return this.curCost;
    }

    public int currentArea() {
        return this.curArea;
    }

    public int currentWidth() {
        return this.curRightEdge - this.curLeftEdge;
    }

    public int currentHeight() {
        return this.curBottomEdge - this.curTopEdge;
    }

    public int currentRightEdge() {
        return this.curRightEdge;
    }

    public int currentLeftEdge() {
        return this.curLeftEdge;
    }

    public int currentBottomEdge() {
        return this.curBottomEdge;
    }

    public int currentTopEdge() {
        return this.curTopEdge;
    }

    public int currentOverlap() {
        return this.curOlap;
    }

    public int currentWirelength() {
        return this.curWirelength;
    }

    public int calcArea() {
        int maxBottom = 0;
        int maxRight = 0;
        int minTop = Integer.MAX_VALUE;
        int minLeft = Integer.MAX_VALUE;
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            PModule pm = (PModule)e.nextElement();
            minLeft = Math.min(minLeft, pm.leftEdge());
            maxRight = Math.max(maxRight, pm.rightEdge());
            minTop = Math.min(minTop, pm.topEdge());
            maxBottom = Math.max(maxBottom, pm.bottomEdge());
        }
        this.curRightEdge = maxRight;
        this.curLeftEdge = minLeft;
        this.curBottomEdge = maxBottom;
        this.curTopEdge = minTop;
        return (maxBottom - minTop) * (maxRight - minLeft);
    }

    public int calcWirelength() {
        int wiresum = 0;
        Enumeration e = this.nets.elements();
        while (e.hasMoreElements()) {
            PNet pn = (PNet)e.nextElement();
            wiresum += pn.netLength();
        }
        return wiresum;
    }

    public void reportCost() {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("area=").append(this.currentArea()).append(" wirelength=").append(this.currentWirelength()).append(" olap=").append(this.currentOverlap()).append(" cost=").append(this.currentCost()))));
    }

    public int calcOverlap() {
        int olap_sum = 0;
        for (int i = 0; i < this.modules.size(); ++i) {
            PModule pmi = (PModule)this.modules.elementAt(i);
            for (int j = i + 1; j < this.modules.size(); ++j) {
                PModule pmj = (PModule)this.modules.elementAt(j);
                olap_sum += pmi.overlapArea(pmj);
            }
        }
        return olap_sum;
    }

    public PModule findModule(String mn) {
        for (int i = 0; i < this.modules.size(); ++i) {
            PModule pm = (PModule)this.modules.elementAt(i);
            if (!mn.equals(pm.getName())) continue;
            return pm;
        }
        return null;
    }

    public void addModule(PModule m) {
        this.modules.addElement(m);
    }

    PModule getModule(int i) {
        return (PModule)this.modules.elementAt(i);
    }

    public PModule selectModule() {
        this.moveModule = (PModule)this.modules.elementAt((int)(Math.random() * (double)this.modules.size()));
        return this.moveModule;
    }

    public int numModules() {
        return this.modules.size();
    }

    private void initMoveLimit() {
        int areaSum = 0;
        for (int i = 0; i < this.modules.size(); ++i) {
            PModule pm = (PModule)this.modules.elementAt(i);
            areaSum += pm.area();
        }
        this.moveLimit = (int)(3.0 * Math.sqrt(areaSum));
        System.out.println("Setting moveLimit=".concat(String.valueOf(String.valueOf(this.moveLimit))));
    }

    public int getMoveLimit() {
        return this.moveLimit;
    }

    public int numNets() {
        return this.nets.size();
    }

    public PNet getNet(int i) {
        return (PNet)this.nets.elementAt(i);
    }

    public PNet findNet(String mn) {
        for (int i = 0; i < this.nets.size(); ++i) {
            PNet pn = (PNet)this.nets.elementAt(i);
            if (!mn.equals(pn.getName())) continue;
            return pn;
        }
        return null;
    }

    public void addNet(PNet n) {
        if (this.nets.contains(n)) {
            System.out.println("Net.addNet: trying to add duplicate net: ".concat(String.valueOf(String.valueOf(n))));
        } else {
            this.nets.addElement(n);
        }
    }

    public void readLayout(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            StringTokenizer t = new StringTokenizer(line);
            System.out.println(line);
            String kw = t.nextToken();
            if (kw.equals("module")) {
                this.addModule(PModule.parseModule(t));
                continue;
            }
            if (kw.equals("terminal")) {
                System.out.println("#PT#");
                PTerminal.parseTerminal(t, this);
                continue;
            }
            if (kw.equals("net")) {
                PNet.parseNet(t, this);
                continue;
            }
            System.out.println("Unrecognized object: ".concat(String.valueOf(String.valueOf(kw))));
        }
        this.initMoveLimit();
    }

    public void readLayout(String fname) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(fname));
            this.readLayout(in);
        }
        catch (FileNotFoundException e) {
            System.out.println("Couldn't open file: ".concat(String.valueOf(String.valueOf(fname))));
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println("Caught IOException: ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    public String toString() {
        String result = String.valueOf(String.valueOf(new StringBuffer("PLayout [area=").append(this.currentArea()).append(" overlap=").append(this.currentOverlap()).append("\n")));
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            PModule pm = (PModule)e.nextElement();
            result = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(result))).append("\t").append(pm).append("\n")));
        }
        result = String.valueOf(String.valueOf(result)).concat("]\n");
        return result;
    }

    public static void main(String[] args) {
        PLayout pl = new PLayout(args[0]);
        System.out.println(pl);
        System.out.println(pl);
    }

    static {
        NO_MOVE = 0;
        H_MOVE = 1;
        V_MOVE = 2;
        R_MOVE = 3;
        K_OLAP = 5;
        K_NETLENGTH = 10;
    }
}

