/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;
import java.util.Vector;

class PModule {
    private int x;
    private int y;
    private int w;
    private int h;
    private String name;
    private static PLayout layout;
    private Vector lnkTerminals = new Vector();

    public static void setLayout(PLayout p) {
        layout = p;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMoveModule() {
        PMove lm = layout.getLastMove();
        if (lm == null) {
            return false;
        }
        return lm.getMoveModule() == this;
    }

    public boolean isRejectedMoveModule() {
        PMove lm = layout.getLastMove();
        if (lm == null) {
            return false;
        }
        return lm.getMoveModule() == this && lm.isRejected();
    }

    public PTerminal getTerminal(int i) {
        return (PTerminal)this.lnkTerminals.elementAt(i);
    }

    public int numTerminals() {
        return this.lnkTerminals.size();
    }

    public void addTerminal(PTerminal t) {
        if (!this.lnkTerminals.contains(t)) {
            this.lnkTerminals.addElement(t);
        }
    }

    public PTerminal findTerminal(String tname) {
        for (int i = 0; i < this.lnkTerminals.size(); ++i) {
            PTerminal pt = (PTerminal)this.lnkTerminals.elementAt(i);
            if (!tname.equals(pt.getName())) continue;
            return pt;
        }
        return null;
    }

    public PModule(String n, int xi, int yi, int wi, int hi) {
        this.name = n;
        this.x = xi;
        this.y = yi;
        this.w = wi;
        this.h = hi;
    }

    void setLocation(int nx, int ny) {
        this.x = nx;
        this.y = ny;
        layout.calcCost();
    }

    public int area() {
        return this.w * this.h;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int leftEdge() {
        return this.x;
    }

    public int rightEdge() {
        return this.x + this.w;
    }

    public int topEdge() {
        return this.y;
    }

    public int bottomEdge() {
        return this.y + this.h;
    }

    public int width() {
        return this.w;
    }

    public int height() {
        return this.h;
    }

    public boolean overlaps(PModule c) {
        if (c.leftEdge() > this.rightEdge()) {
            return false;
        }
        if (c.rightEdge() < this.leftEdge()) {
            return false;
        }
        if (c.bottomEdge() < this.topEdge()) {
            return false;
        }
        return c.topEdge() <= this.bottomEdge();
    }

    public int overlapArea(PModule c) {
        if (!this.overlaps(c)) {
            return 0;
        }
        int left = Math.max(c.leftEdge(), this.leftEdge());
        int right = Math.min(c.rightEdge(), this.rightEdge());
        int top = Math.max(c.topEdge(), this.topEdge());
        int bottom = Math.min(c.bottomEdge(), this.bottomEdge());
        return (bottom - top) * (right - left);
    }

    public int getMoveLimit() {
        return layout.getMoveLimit();
    }

    public int move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        layout.calcCost();
        return layout.getDeltaCost();
    }

    public int rotate() {
        int tw = this.w;
        this.w = this.h;
        this.h = tw;
        for (int i = 0; i < this.lnkTerminals.size(); ++i) {
            PTerminal pt = (PTerminal)this.lnkTerminals.elementAt(i);
            pt.rotate();
        }
        layout.calcCost();
        return layout.getDeltaCost();
    }

    public int flipVertical() {
        for (int i = 0; i < this.lnkTerminals.size(); ++i) {
            PTerminal pt = (PTerminal)this.lnkTerminals.elementAt(i);
            pt.flipVertical();
        }
        layout.calcCost();
        return layout.getDeltaCost();
    }

    public int flipHorizontal() {
        for (int i = 0; i < this.lnkTerminals.size(); ++i) {
            PTerminal pt = (PTerminal)this.lnkTerminals.elementAt(i);
            pt.flipHorizontal();
        }
        layout.calcCost();
        return layout.getDeltaCost();
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("PModule ").append(this.name).append("(").append(this.x).append(",").append(this.y).append(",").append(this.w).append(",").append(this.h).append(") area=").append(this.area())));
    }

    public static PModule parseModule(StringTokenizer t) {
        String rname = t.nextToken();
        int x = Integer.parseInt(t.nextToken());
        int y = Integer.parseInt(t.nextToken());
        int w = Integer.parseInt(t.nextToken());
        int h = Integer.parseInt(t.nextToken());
        return new PModule(rname, x, y, w, h);
    }

    public static void main(String[] args) {
        PModule c1 = new PModule("r1", 3, 3, 4, 4);
        PModule c2 = new PModule("r2", 2, 5, 3, 3);
        PModule c3 = new PModule("r3", 8, 2, 2, 5);
        System.out.println("c1: ".concat(String.valueOf(String.valueOf(c1))));
        System.out.println("c2: ".concat(String.valueOf(String.valueOf(c2))));
        System.out.println("c3: ".concat(String.valueOf(String.valueOf(c3))));
        System.out.println("c1.overlaps(c2) => ".concat(String.valueOf(String.valueOf(c1.overlaps(c2)))));
        System.out.println("c1.overlaps(c3) => ".concat(String.valueOf(String.valueOf(c1.overlaps(c3)))));
        System.out.println("c2.overlaps(c2) => ".concat(String.valueOf(String.valueOf(c2.overlaps(c3)))));
        System.out.println("c1.overlapArea(c2) => ".concat(String.valueOf(String.valueOf(c1.overlapArea(c2)))));
        System.out.println("c1.overlapArea(c3) => ".concat(String.valueOf(String.valueOf(c1.overlapArea(c3)))));
        System.out.println("c2.overlapArea(c3) => ".concat(String.valueOf(String.valueOf(c2.overlapArea(c3)))));
    }
}

