/*
 * Decompiled with CFR 0.152.
 */
public abstract class PMove {
    protected PModule moveModule;
    protected boolean rejected = false;
    protected int deltaCost = 0;
    private static int windowX = 0;
    private static int windowY = 0;
    private static double logT0 = 0.0;
    private static double windowScale = 0.0;

    public static PMove selectMove(PModule pm) {
        double r = Math.random();
        if (r < 0.45) {
            return new PMoveV(pm);
        }
        if (r < 0.9) {
            return new PMoveH(pm);
        }
        if (r < 0.933) {
            return new PMoveRotate(pm);
        }
        if (r < 0.967) {
            return new PMoveFlipH(pm);
        }
        return new PMoveFlipV(pm);
    }

    protected String moveString(String mstr) {
        mstr = String.valueOf(String.valueOf(mstr)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" ").append(this.moveModule.getName()).append(" dCost=").append(this.deltaCost))))));
        if (this.rejected) {
            return String.valueOf(String.valueOf(mstr)).concat(" [Rejected]");
        }
        return mstr;
    }

    public PMove(PModule pm) {
        this.moveModule = pm;
    }

    public int getDeltaCost() {
        return this.deltaCost;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public PModule getMoveModule() {
        return this.moveModule;
    }

    void undo() {
        if (this.rejected) {
            System.out.println("PMove.undo(): can't undo a rejected move!");
        }
        this.rejected = true;
    }

    public static void setWindow(int wx, int wy) {
        windowX = wx;
        windowY = wy;
    }

    public static void setT0(double t) {
        logT0 = Math.log(t);
        windowScale = 1.0;
    }

    public static void setT(double t) {
        windowScale = t == Double.POSITIVE_INFINITY ? 1.0 : Math.log(t) / logT0;
    }

    public static int genX() {
        if (windowScale <= 0.0) {
            return 1;
        }
        return (int)((double)windowX * windowScale);
    }

    public static int genY() {
        if (windowScale <= 0.0) {
            return 1;
        }
        return (int)((double)windowY * windowScale);
    }
}

