/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;

class PNet {
    private Vector terminals = new Vector();
    private String name;

    public String getName() {
        return this.name;
    }

    public PNet(String n) {
        this.name = n;
    }

    public String toString() {
        String s = String.valueOf(String.valueOf(new StringBuffer("PNet ").append(this.getName()).append("[")));
        for (int i = 0; i < this.terminals.size(); ++i) {
            PTerminal pt = this.getTerminal(i);
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(pt))))));
        }
        s = String.valueOf(String.valueOf(s)).concat(" ]");
        return s;
    }

    public int netLength() {
        int miny;
        int minx;
        int maxx = minx = this.getTerminal(0).getLayoutX();
        int maxy = miny = this.getTerminal(0).getLayoutY();
        for (int i = 1; i < this.numTerminals(); ++i) {
            PTerminal t = this.getTerminal(i);
            minx = Math.min(minx, t.getLayoutX());
            maxx = Math.max(maxx, t.getLayoutX());
            miny = Math.min(miny, t.getLayoutY());
            maxy = Math.max(maxy, t.getLayoutY());
        }
        return maxy - miny + (maxx - minx);
    }

    void addTerminal(PTerminal t) {
        this.terminals.addElement(t);
    }

    int numTerminals() {
        return this.terminals.size();
    }

    PTerminal getTerminal(int i) {
        return (PTerminal)this.terminals.elementAt(i);
    }

    public void paintNet(Graphics g) {
        g.setColor(Color.black);
        if (this.numTerminals() <= 1) {
            return;
        }
        PTerminal ot = this.getTerminal(0);
        g.setColor(Color.red);
        for (int i = 1; i < this.numTerminals(); ++i) {
            PTerminal dt = this.getTerminal(i);
            g.drawLine(ot.getX(), ot.getY(), dt.getX(), dt.getY());
        }
    }

    static PNet parseNet(StringTokenizer t, PLayout pl) {
        String nname = t.nextToken();
        PNet n = new PNet(nname);
        while (t.hasMoreTokens()) {
            String mtname = t.nextToken();
            String tname = t.nextToken();
            PModule mt = pl.findModule(mtname);
            if (mt == null) {
                System.out.println("Net.parseNet: could not find connecting module: ".concat(String.valueOf(String.valueOf(mtname))));
                continue;
            }
            PTerminal pt = mt.findTerminal(tname);
            if (pt == null) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Net.parseNet: could not find connecting terminal: ").append(mtname).append(":").append(tname))));
                continue;
            }
            n.addTerminal(pt);
        }
        pl.addNet(n);
        return n;
    }
}

