/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class PTempHistory {
    private double temperature = 0.0;
    private double maxCost = 0.0;
    private double minCost = Double.MAX_VALUE;
    private double averageCost = 0.0;
    private double sumCost = 0.0;
    private int attemptCount = 0;
    private int acceptCount = 0;
    private int rejectCount = 0;
    public Vector samples = new Vector(500);

    public PTempHistory(double t) {
        this.temperature = t;
    }

    public PTempHistory() {
        this(0.0);
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getMaxCost() {
        return this.maxCost;
    }

    public double getMinCost() {
        return this.minCost;
    }

    public double getAverage() {
        return this.averageCost;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public int getRejectCount() {
        return this.rejectCount;
    }

    public double getAcceptPercent() {
        return (double)this.acceptCount / (double)(this.acceptCount + this.rejectCount) * 100.0;
    }

    public double getStdev() {
        double stdevSum = 0.0;
        for (int i = 0; i < this.samples.size(); ++i) {
            Double s = (Double)this.samples.elementAt(i);
            double diff = s - this.averageCost;
            stdevSum += diff * diff;
        }
        return Math.sqrt(stdevSum / (double)(this.acceptCount - 1));
    }

    public void addSample(double sampleCost, boolean accepted) {
        ++this.attemptCount;
        if (accepted) {
            this.minCost = Math.min(this.minCost, sampleCost);
            this.maxCost = Math.max(this.maxCost, sampleCost);
            this.sumCost += sampleCost;
            this.samples.addElement(new Double(sampleCost));
            ++this.acceptCount;
            this.averageCost = this.sumCost / (double)this.acceptCount;
        } else {
            ++this.rejectCount;
        }
    }
}

