/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

class PTerminal {
    private String name;
    private PModule parent;
    private int xoff;
    private int yoff;
    private PNet tnet;

    public PTerminal(String n, PModule p, int xo, int yo) {
        this.name = n;
        this.parent = p;
        this.xoff = xo;
        this.yoff = yo;
    }

    public String getName() {
        return this.name;
    }

    public PModule getParent() {
        return this.parent;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("PTerminal ").append(this.name).append(" module ").append(this.getParent().getName()).append("(").append(this.xoff).append(",").append(this.yoff).append(")")));
    }

    void rotate() {
        int newx = this.getParent().width() - this.yoff;
        this.yoff = this.xoff;
        this.xoff = newx;
    }

    void flipVertical() {
        this.yoff = this.getParent().height() - this.yoff;
    }

    void flipHorizontal() {
        this.xoff = this.getParent().width() - this.xoff;
    }

    public int getX() {
        return this.xoff;
    }

    public int getY() {
        return this.yoff;
    }

    public int getLayoutX() {
        return this.parent.getX() + this.xoff;
    }

    public int getLayoutY() {
        return this.parent.getY() + this.yoff;
    }

    public void connectNet(PNet n) {
        this.tnet = n;
    }

    public void disconnectNet() {
        this.tnet = null;
    }

    public void paintTerminal(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(this.getX() - 2, this.getY() - 2, 5, 5);
    }

    public static PTerminal parseTerminal(StringTokenizer t, PLayout pl) {
        String tname = t.nextToken();
        String mname = t.nextToken();
        PModule m = pl.findModule(mname);
        int x = Integer.parseInt(t.nextToken());
        int y = Integer.parseInt(t.nextToken());
        PTerminal pt = new PTerminal(tname, m, x, y);
        m.addTerminal(pt);
        return pt;
    }
}

