/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class UIAnnealer
extends JPanel
implements Runnable,
ActionListener {
    private PAnnealer myAnnealer;
    private static final int STOP = 0;
    private static final int RUN = 1;
    private static final int PAUSE = 2;
    private static final int STEP = 3;
    private int state = 0;
    private boolean animate = true;
    private Thread runner = null;
    private UIOptionsDialog myDialog;
    private double optT0 = 1.0E-4;
    private boolean optT0Adaptive = true;
    private boolean optAnimateMoves = true;
    private int optMovesPerTemp = 0;
    private boolean optMovesPerTempPerModule = false;
    private double optCoolRate = 0.95;
    private int optSpeed = 50;
    private JPanel historyPanel;
    private JPanel statusPanel;
    private JPanel controlPanel;
    private JToggleButton stopButton = new JToggleButton("STOP", true);
    private JToggleButton runButton = new JToggleButton("RUN");
    private JToggleButton pauseButton = new JToggleButton("PAUSE");
    private JToggleButton stepButton = new JToggleButton("STEP");
    private ButtonGroup bg = new ButtonGroup();
    private JLabel tempLabel = new JLabel("T=");
    private JTextField tempField = new JTextField(8);
    private UIValDisplay tempDisplay = new UIValDisplay("Temperature", 0);
    private UIValDisplay attemptsDisplay = new UIValDisplay("Attempts", 0);
    private UIValDisplay acceptedDisplay = new UIValDisplay("Accepted", 0);
    private UIValDisplay percentDisplay = new UIValDisplay("%", 0);
    private static int ANIMATE_DELAY;

    public void setOptT0Adaptive(boolean b) {
        this.optT0Adaptive = b;
    }

    public void setOptInitialTemperature(double t0) {
        this.optT0 = t0;
    }

    public void setOptAnimateMoves(boolean b) {
        this.optAnimateMoves = b;
    }

    public void setOptMovesPerTemp(int m) {
        this.optMovesPerTemp = m;
    }

    public int getOptMovesPerTemp() {
        return this.optMovesPerTemp;
    }

    public void setOptMovesPerTempPerModule(boolean b) {
        this.optMovesPerTempPerModule = b;
    }

    public boolean getOptMovesPerTempPerModule() {
        return this.optMovesPerTempPerModule;
    }

    public void setOptCoolRate(double d) {
        this.optCoolRate = d;
    }

    public double getOptCoolRate() {
        return this.optCoolRate;
    }

    public void setOptSpeed(int s) {
        this.optSpeed = s;
    }

    public int getOptSpeed() {
        return this.optSpeed;
    }

    public UIAnnealer(PAnnealer p) {
        this.myAnnealer = p;
        this.setLayout(new BorderLayout());
        JPanel statusPanel = new JPanel(new GridLayout(1, 5));
        statusPanel.add(this.tempDisplay);
        statusPanel.add(this.attemptsDisplay);
        statusPanel.add(this.acceptedDisplay);
        statusPanel.add(this.percentDisplay);
        JPanel controlPanel = new JPanel(new FlowLayout());
        this.bg.add(this.stopButton);
        this.bg.add(this.runButton);
        this.bg.add(this.pauseButton);
        this.bg.add(this.stepButton);
        this.stopButton.setActionCommand("STOP");
        this.runButton.setActionCommand("RUN");
        this.pauseButton.setActionCommand("PAUSE");
        this.stepButton.setActionCommand("STEP");
        this.stopButton.addActionListener(this);
        this.runButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.stepButton.addActionListener(this);
        controlPanel.add(this.stopButton);
        controlPanel.add(this.runButton);
        controlPanel.add(this.pauseButton);
        controlPanel.add(this.stepButton);
        this.add((Component)statusPanel, "North");
        this.add((Component)controlPanel, "South");
        this.historyPanel = new UITempHistory(p);
        this.add((Component)this.historyPanel, "Center");
        this.myDialog = new UIOptionsDialog(this);
        this.myDialog.pack();
        ((Component)this.myDialog).setVisible(true);
        this.myDialog.repaint();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "STOP") {
            this.runButton.enable();
            this.pauseButton.disable();
            this.stepButton.disable();
            this.state = 0;
            if (this.runner != null) {
                this.runner.interrupt();
                this.runner = null;
            }
        } else if (cmd == "RUN") {
            this.pauseButton.enable();
            this.stepButton.disable();
            if (this.state == 0) {
                if (this.runner == null) {
                    this.runner = new Thread(this);
                    this.runner.start();
                    this.state = 1;
                } else {
                    System.out.println("trying to start but non-null thread");
                }
            } else if (this.state == 2) {
                this.state = 1;
                this.notifyAll();
            }
        } else if (cmd == "PAUSE") {
            if (this.state == 0) {
                this.stopButton.setSelected(true);
            } else {
                this.stepButton.enable();
                this.state = 2;
            }
        } else if (cmd == "STEP") {
            if (this.state == 0) {
                this.stopButton.setSelected(true);
            } else {
                this.state = 3;
                this.notifyAll();
            }
        }
    }

    public void run() {
        try {
            System.out.println("starting annealing run!");
            if (this.optT0Adaptive) {
                this.myAnnealer.findT0(this.optAnimateMoves);
            } else {
                this.myAnnealer.setT0(this.optT0);
            }
            this.myAnnealer.anneal(this.optAnimateMoves);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("annealing done");
        this.state = 0;
        this.stopButton.setSelected(true);
        this.runner = null;
    }

    void setAnnealDisplay(PTempHistory pt) {
        this.tempDisplay.setValue(pt.getTemperature());
        this.attemptsDisplay.setValue(pt.getAttemptCount());
        this.acceptedDisplay.setValue(pt.getAcceptCount());
        this.percentDisplay.setValue(pt.getAcceptPercent());
    }

    public synchronized void animateStep() throws InterruptedException {
        this.getParent().repaint();
        Thread.sleep(ANIMATE_DELAY / this.optSpeed);
        if (this.state == 3) {
            this.state = 2;
            this.pauseButton.setSelected(true);
        }
        while (this.state == 2) {
            this.wait();
        }
    }

    public static void main(String[] args) {
        PLayout pl = new PLayout("ntest.in");
        JFrame jf = new JFrame("UIAnnealer Test");
        JPanel stuffPanel = new JPanel(new GridLayout(1, 2));
        UILayout uil = new UILayout(pl);
        stuffPanel.add(uil);
        ((Component)jf).setSize(600, 300);
        PAnnealer pa = new PAnnealer(pl);
        UIAnnealer ua = new UIAnnealer(pa);
        stuffPanel.add(ua);
        jf.getContentPane().add(stuffPanel);
        pa.setUIAnnealer(ua);
        ((Component)jf).setVisible(true);
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        uil.autoZoom();
    }

    static {
        STOP = 0;
        RUN = 1;
        PAUSE = 2;
        STEP = 3;
        ANIMATE_DELAY = 4000;
    }
}

