/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UILayout
extends JPanel {
    JPanel messagePanel;
    private static double zoom = 2.0;
    private PLayout myLayout;
    private JPanel placementPanel;
    private JPanel statusPanel;
    private UIValDisplay areaDisplay;
    private UIValDisplay olapDisplay;
    private UIValDisplay wireDisplay;
    private UIValDisplay costDisplay;
    private JLabel messageLabel;

    public UILayout(PLayout ml) {
        System.out.println("ULayout constructor");
        this.myLayout = ml;
        this.setLayout(new BorderLayout());
        this.placementPanel = new UIPlacementPanel(this.myLayout);
        this.add((Component)this.placementPanel, "Center");
        this.placementPanel.setLayout(null);
        this.placementPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)this.placementPanel, "Center");
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new GridLayout(1, 4));
        this.areaDisplay = new UIValDisplay("Area", 0);
        this.statusPanel.add(this.areaDisplay);
        this.olapDisplay = new UIValDisplay("Overlap", 0);
        this.statusPanel.add(this.olapDisplay);
        this.wireDisplay = new UIValDisplay("Wirelength", 0);
        this.statusPanel.add(this.wireDisplay);
        this.costDisplay = new UIValDisplay("Cost", 0);
        this.statusPanel.add(this.costDisplay);
        this.add((Component)this.statusPanel, "North");
        this.messagePanel = new JPanel();
        this.messageLabel = new JLabel("This Space for Rent");
        this.messagePanel.add(this.messageLabel);
        this.add((Component)this.messagePanel, "South");
        this.addModules();
        this.myLayout.calcCost();
    }

    private void addModules() {
        for (int i = 0; i < this.myLayout.numModules(); ++i) {
            PModule pm = this.myLayout.getModule(i);
            this.placementPanel.add(new UIModule(pm));
        }
    }

    public void setMessage(String m) {
        this.messageLabel.setText(m);
        this.messagePanel.repaint();
    }

    public void setMoveMessage() {
        PMove lastMove = this.myLayout.getLastMove();
        if (lastMove != null) {
            this.setMessage(lastMove.toString());
        } else {
            this.setMessage("");
        }
    }

    public void setCostDisplay() {
        this.areaDisplay.setValue(this.myLayout.currentArea());
        this.olapDisplay.setValue(this.myLayout.currentOverlap());
        this.wireDisplay.setValue(this.myLayout.currentWirelength());
        this.costDisplay.setValue(this.myLayout.currentCost());
        this.statusPanel.repaint();
    }

    public void paintComponent(Graphics g) {
        this.setCostDisplay();
        this.setMoveMessage();
        super.paintComponent(g);
    }

    public static int scale(int i) {
        return (int)((double)i * zoom);
    }

    public static int unscale(int i) {
        return (int)((double)i / zoom);
    }

    public static void setZoom(double s) {
        zoom = s;
    }

    public void autoZoom() {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("autoZoom: panelw =").append(this.placementPanel.getWidth()).append(" panelh =").append(this.placementPanel.getHeight()).append(" lb=").append(this.myLayout.currentBottomEdge()).append(" lr=").append(this.myLayout.currentRightEdge()))));
        double vscale = 0.9 * (double)this.placementPanel.getWidth() / (double)this.myLayout.currentRightEdge();
        double hscale = 0.9 * (double)this.placementPanel.getHeight() / (double)this.myLayout.currentBottomEdge();
        zoom = Math.min(vscale, hscale);
        System.out.println("autozoom: zoom = ".concat(String.valueOf(String.valueOf(zoom))));
    }

    public static void main(String[] args) {
        PLayout test = new PLayout("ntest.in");
        JFrame jf = new JFrame("UILayout Test");
        UILayout uil = new UILayout(test);
        uil.setSize(200, 200);
        ((Component)jf).setSize(300, 300);
        jf.getContentPane().add(uil);
        ((Component)jf).setVisible(true);
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        uil.autoZoom();
    }
}

