/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class UIModule
extends JLabel {
    private static DragListener dragger = new DragListener();
    private PModule myModule;

    public UIModule(PModule mod) {
        this.addMouseMotionListener(dragger);
        this.addMouseListener(dragger);
        this.myModule = mod;
        this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.setText(mod.getName());
        this.setBackground(Color.yellow);
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("UIModule:").append(mod.getName()).append(" width= ").append(mod.width()).append(" (").append(UILayout.scale(mod.width())).append(") height=").append(mod.height()).append(" (").append(UILayout.scale(mod.height())).append(")"))));
        this.setSize(UILayout.scale(mod.width()), UILayout.scale(mod.height()));
        super.setLocation(UILayout.scale(mod.getX()), UILayout.scale(mod.getY()));
    }

    public void updateLocation() {
        this.setSize(UILayout.scale(this.myModule.width()), UILayout.scale(this.myModule.height()));
        super.setLocation(UILayout.scale(this.myModule.getX()), UILayout.scale(this.myModule.getY()));
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.myModule.setLocation(UILayout.unscale(x), UILayout.unscale(y));
    }

    public void flipHorizontal() {
        System.out.println("flipHorizontal ".concat(String.valueOf(String.valueOf(this.getText()))));
        this.myModule.flipHorizontal();
        this.getParent().getParent().repaint();
    }

    public void flipVertical() {
        System.out.println("flipVertical ".concat(String.valueOf(String.valueOf(this.getText()))));
        this.myModule.flipVertical();
        this.getParent().getParent().repaint();
    }

    public void rotate() {
        System.out.println("rotate ".concat(String.valueOf(String.valueOf(this.getText()))));
        this.myModule.rotate();
        this.getParent().getParent().repaint();
    }

    public void paintComponent(Graphics g) {
        this.updateLocation();
        if (this.myModule.isMoveModule()) {
            if (this.myModule.isRejectedMoveModule()) {
                this.setBackground(Color.red);
            } else {
                this.setBackground(Color.green);
            }
        } else {
            this.setBackground(Color.yellow);
        }
        super.paintComponent(g);
        for (int i = 0; i < this.myModule.numTerminals(); ++i) {
            PTerminal pt = this.myModule.getTerminal(i);
            g.setColor(Color.black);
            int tx = Math.max(UILayout.scale(pt.getX()) - 2, 0);
            int ty = Math.max(UILayout.scale(pt.getY()) - 2, 0);
            tx = Math.min(tx, UILayout.scale(this.myModule.width()) - 5);
            ty = Math.min(ty, UILayout.scale(this.myModule.height()) - 5);
            g.fillRect(tx, ty, 5, 5);
        }
    }
}

