/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.TreeSet;

class Grid
extends Panel {
    private String msg = null;
    Image myOffScreenImage = null;
    Graphics myOffScreenGraphics = null;
    private TreeSet gpq = new TreeSet();
    private int queueCount = 0;
    private static final int DELAY = 100;
    static final int GRIDSIZE = 19;
    static final int CHARXOFFSET = 6;
    static final int CHARYOFFSET = 14;
    private GridPoint clickedPoint = null;
    private boolean clearPending = false;
    private static final int WAITFORSRC = 0;
    private static final int WAITFORTGT = 1;
    GridPoint[][][] gridArray;
    GridPoint src;
    GridPoint tgt;

    public Grid(int n, int n2, int n3) {
        this.gridArray = new GridPoint[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.gridArray[i][j][k] = new GridPoint(i, j, k);
                }
            }
        }
        GridPoint.myGrid = this;
        this.setSize(this.pixelWidth(), this.pixelHeight());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Grid.this.handleMouseClick(mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public void setMessage(String string) {
        this.msg = string;
        this.redrawGrid();
    }

    public void flash(GridPoint gridPoint) throws InterruptedException {
        for (int i = 0; i < 3; ++i) {
            gridPoint.highlight(true);
            this.redrawGrid();
            Grid.gridDelay(4);
            gridPoint.highlight(false);
            this.redrawGrid();
            Grid.gridDelay(4);
        }
    }

    public void redrawGrid() {
        if (this.myOffScreenImage == null) {
            this.myOffScreenImage = this.createImage(this.getSize().width, this.getSize().height);
            this.myOffScreenGraphics = this.myOffScreenImage.getGraphics();
        }
        this.repaint();
    }

    public int width() {
        return this.gridArray.length;
    }

    public int height() {
        return this.gridArray[0].length;
    }

    public int depth() {
        return this.gridArray[0][0].length;
    }

    public int pixelWidth() {
        return this.width() * 19;
    }

    public int pixelHeight() {
        return this.depth() * (this.height() + 1) * 19;
    }

    public static int calculateCols(int n) {
        return (n - 2) / 19;
    }

    public static int calculateRows(int n, int n2) {
        int n3 = (n - 30) / 19 - 2;
        return n3 / n2 - 1;
    }

    public GridPoint gridPointAt(int n, int n2, int n3) {
        if (n < 0 || n >= this.width()) {
            return null;
        }
        if (n2 < 0 || n2 >= this.height()) {
            return null;
        }
        if (n3 < 0 || n3 >= this.depth()) {
            return null;
        }
        return this.gridArray[n][n2][n3];
    }

    public void reset() {
        for (int i = 0; i < this.width(); ++i) {
            for (int j = 0; j < this.height(); ++j) {
                for (int k = 0; k < this.depth(); ++k) {
                    GridPoint gridPoint = this.gridPointAt(i, j, k);
                    if (gridPoint.isObstacle()) continue;
                    gridPoint.reset();
                }
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.width(); ++i) {
            for (int j = 0; j < this.height(); ++j) {
                for (int k = 0; k < this.depth(); ++k) {
                    GridPoint gridPoint = this.gridPointAt(i, j, k);
                    gridPoint.reset();
                }
            }
        }
    }

    void resetGridPointQueue() {
        this.gpq.clear();
        this.queueCount = 0;
    }

    void printGridPointQueue() {
        Iterator iterator = this.gpq.iterator();
        System.out.println("Queue contents [" + this.gpq.size() + "]: ");
        while (iterator.hasNext()) {
            GridPoint gridPoint = (GridPoint)iterator.next();
            System.out.print(gridPoint + " ");
        }
        System.out.println();
    }

    public void enqueueGridPoint(GridPoint gridPoint) throws InterruptedException {
        gridPoint.setQVal(++this.queueCount);
        this.gpq.add(gridPoint);
        gridPoint.setEnqueued(true);
        System.out.println("Added gridpoint: " + gridPoint);
        this.redrawGrid();
        Grid.gridDelay();
    }

    public GridPoint dequeueGridPoint() {
        if (this.gpq.size() == 0) {
            return null;
        }
        GridPoint gridPoint = (GridPoint)this.gpq.first();
        this.printGridPointQueue();
        if (!this.gpq.remove(gridPoint)) {
            System.out.println("-----REMOVE FAILED!");
        }
        return gridPoint;
    }

    public void clearQueue() {
        this.gpq.clear();
    }

    public static void gridDelay(int n) throws InterruptedException {
        Thread.sleep(n * 100);
    }

    public static void gridDelay() throws InterruptedException {
        Grid.gridDelay(1);
    }

    public int expansion() throws InterruptedException {
        boolean bl = false;
        this.setMessage("Expansion phase");
        this.resetGridPointQueue();
        Grid.gridDelay(3);
        if (this.src != null && this.tgt != null) {
            GridPoint gridPoint;
            this.src.initExpand();
            int n = this.src.expand();
            if (n > 0) {
                this.clearQueue();
                return n;
            }
            while ((gridPoint = this.dequeueGridPoint()) != null) {
                this.printGridPointQueue();
                n = gridPoint.expand();
                if (n <= 0) continue;
                this.clearQueue();
                return n;
            }
        }
        return -1;
    }

    public void traceBack() throws InterruptedException {
        GridPoint gridPoint = this.tgt;
        while (!gridPoint.isSource()) {
            int n = gridPoint.getGVal();
            this.setMessage("Traceback: distance = " + n);
            gridPoint.setRouted();
            this.redrawGrid();
            Grid.gridDelay(3);
            GridPoint gridPoint2 = gridPoint.westNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getGVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.eastNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getGVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.southNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getGVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.northNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getGVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.upNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getGVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            gridPoint2 = gridPoint.downNeighbor();
            if (gridPoint2 != null && !gridPoint2.isObstacle() && gridPoint2.getGVal() < n) {
                gridPoint = gridPoint2;
                continue;
            }
            System.out.println("AWK! can't trace back! current= " + gridPoint);
            break;
        }
        if (gridPoint.isSource()) {
            this.setMessage("Traceback complete");
            this.flash(gridPoint);
            gridPoint.setRouted();
        } else {
            System.out.println("Warning: traceBack failed!");
        }
    }

    int gridPanelX(int n, int n2, int n3) {
        return n * 19;
    }

    int gridPanelY(int n, int n2, int n3) {
        return n3 * (19 * (this.height() + 1)) + (n2 + 1) * 19;
    }

    int gridLyrY(int n) {
        return 19 * n * (this.height() + 1) + 14;
    }

    int gridMsgY() {
        return 19 * this.depth() * (this.height() + 1) + 14;
    }

    public synchronized void handleMouseClick(int n, int n2) {
        this.clickedPoint = this.mouseToGridPoint(n, n2);
        this.notifyAll();
    }

    public synchronized void requestClear() {
        this.clearPending = true;
        this.notifyAll();
    }

    GridPoint mouseToGridPoint(int n, int n2) {
        int n3 = n / 19;
        for (int i = 0; i < this.depth(); ++i) {
            if (n2 < this.gridPanelY(0, 0, i) || n2 > this.gridPanelY(0, 0, i + 1) - 19) continue;
            int n4 = n2 % ((this.height() + 1) * 19) / 19 - 1;
            if (n3 >= 0 && n3 < this.width() && n4 >= 0 && n4 < this.height() && i >= 0 && i < this.depth()) {
                return this.gridPointAt(n3, n4, i);
            }
            return null;
        }
        return null;
    }

    private synchronized void waitForInput() throws InterruptedException {
        while (!this.clearPending && this.clickedPoint == null) {
            this.wait();
        }
    }

    public void run() throws InterruptedException {
        this.clear();
        boolean bl = false;
        this.setMessage("Click on Source");
        while (true) {
            this.waitForInput();
            if (!bl) {
                if (this.clearPending) {
                    this.clear();
                    this.setMessage("Grid cleared!");
                    Grid.gridDelay(5);
                    this.setMessage("Click on Source");
                    this.clearPending = false;
                    continue;
                }
                if (this.clickedPoint == null) continue;
                if (!this.clickedPoint.isRouted()) {
                    this.setSource(this.clickedPoint);
                    System.out.println("Setting source: " + this.clickedPoint);
                    bl = true;
                    this.setMessage("Click on Target");
                } else {
                    this.setMessage("Already routed!");
                    Grid.gridDelay(5);
                    this.setMessage("Click on Source");
                }
                this.clickedPoint = null;
                continue;
            }
            if (!bl) continue;
            if (this.clickedPoint != null) {
                this.setTarget(this.clickedPoint);
                System.out.println("Setting target: " + this.clickedPoint);
                this.clickedPoint = null;
                this.setMessage("Ready to Route!");
                Grid.gridDelay(5);
                this.redrawGrid();
                this.route();
                this.src = null;
                this.tgt = null;
                bl = false;
                this.setMessage("Click on Source");
                this.redrawGrid();
            }
            this.clearPending = false;
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        for (int i = 0; i < this.depth(); ++i) {
            graphics.setColor(Color.black);
            graphics.drawString("Layer " + (i + 1), 6, this.gridLyrY(i));
            for (int j = 0; j < this.height(); ++j) {
                for (int k = 0; k < this.width(); ++k) {
                    this.gridArray[k][j][i].paintGridPoint(graphics);
                }
            }
        }
        if (this.msg != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this.msg, 6, this.gridMsgY());
        }
    }

    public void update(Graphics graphics) {
        this.paint(this.myOffScreenGraphics);
        graphics.drawImage(this.myOffScreenImage, 0, 0, this);
    }

    public void setSource(int n, int n2, int n3) {
        this.setSource(this.gridArray[n][n2][n3]);
    }

    public void setSource(GridPoint gridPoint) {
        this.src = gridPoint;
    }

    public void setTarget(int n, int n2, int n3) {
        this.tgt = this.gridArray[n][n2][n3];
    }

    public void setTarget(GridPoint gridPoint) {
        this.tgt = gridPoint;
    }

    public GridPoint getSource() {
        return this.src;
    }

    public GridPoint getTarget() {
        return this.tgt;
    }

    public int route() throws InterruptedException {
        if (this.src == null || this.tgt == null) {
            return -1;
        }
        GridPoint.nextRouteColor();
        this.reset();
        if (this.src == this.tgt) {
            this.src.setRouted();
            return 0;
        }
        int n = this.expansion();
        this.clearQueue();
        this.redrawGrid();
        if (n > 0) {
            this.setMessage("Target Found!");
            this.flash(this.tgt);
            this.traceBack();
        } else {
            this.setMessage("Target not found!");
        }
        this.reset();
        this.redrawGrid();
        return n;
    }

    public int route(GridPoint gridPoint, GridPoint gridPoint2) throws InterruptedException {
        this.setSource(gridPoint);
        this.setTarget(gridPoint2);
        return this.route();
    }

    public int route(int n, int n2, int n3, int n4, int n5, int n6) throws InterruptedException {
        return this.route(this.gridPointAt(n, n2, n3), this.gridPointAt(n4, n5, n6));
    }
}

