/*
 * Decompiled with CFR 0.152.
 */
public class PAnnealer
implements PAnnealInterface {
    private PTempHistory tempHistory = new PTempHistory();
    private UIAnnealer myUI;
    private PLayout myLayout;
    private double currentTemperature;
    private static final int SIGMA_MULTIPLIER = 20;

    public PTempHistory getTempHistory() {
        return this.tempHistory;
    }

    public PAnnealer(PLayout pLayout, UIAnnealer uIAnnealer) {
        this.myLayout = pLayout;
        this.myUI = uIAnnealer;
    }

    private double getT() {
        return this.currentTemperature;
    }

    private void setT(double d) {
        this.currentTemperature = d;
        PMove.setT(d);
    }

    public void setT0(double d) {
        this.currentTemperature = d;
        PMove.setT0(d);
    }

    public void findT0() throws InterruptedException {
        this.setT0(Double.POSITIVE_INFINITY);
        this.tempHistory.reset();
        this.showUpdateTemperature();
        this.tempHistory.addTempPoint(this.getT());
        this.metropolis(this.tempHistory);
        double d = this.tempHistory.getCurrentTempPoint().getStdev();
        this.setT0(d * 20.0);
    }

    public boolean terminate(int n, int n2) {
        int n3 = this.tempHistory.numTempPoints();
        if (n3 < n2) {
            return false;
        }
        double d = this.tempHistory.getTempPoint(n3 - 1).getMinCost();
        int n4 = n3 - 2;
        while (n4 >= n3 - n2) {
            double d2 = this.tempHistory.getTempPoint(n4).getMinCost();
            if (d < d2 && (int)((d2 - d) / d2 * 100.0) > n) {
                return false;
            }
            d = d2;
            --n4;
        }
        return true;
    }

    public boolean terminate(int n) {
        int n2 = this.tempHistory.numTempPoints();
        if (n2 < n) {
            return false;
        }
        double d = this.tempHistory.getTempPoint(n2 - 1).getMinCost();
        int n3 = n2 - 2;
        while (n3 >= n2 - n) {
            double d2 = this.tempHistory.getTempPoint(n3).getMinCost();
            if (d != d2) {
                return false;
            }
            --n3;
        }
        return true;
    }

    public boolean accept(double d) {
        if (d <= 0.0) {
            return true;
        }
        if (this.getT() == Double.POSITIVE_INFINITY) {
            return true;
        }
        return Math.random() < Math.exp(-d / this.getT());
    }

    public void metropolis(PTempHistory pTempHistory) throws InterruptedException {
        int n = this.myUI.getOptMovesPerTemp();
        if (this.myUI.getOptMovesPerTempPerModule()) {
            n *= this.myLayout.numModules();
        }
        int n2 = 0;
        while (n2 < n) {
            this.myLayout.selectMove();
            this.showSelectMove();
            int n3 = this.myLayout.applyMove();
            if (this.accept(n3)) {
                this.myLayout.acceptMove();
                this.showAcceptMove();
            } else {
                this.myLayout.rejectMove();
                this.showRejectMove();
            }
            this.myLayout.completeMove();
            this.showCompleteMove();
            ++n2;
        }
    }

    public void anneal() throws InterruptedException {
        PMove.setWindow(2 * this.myLayout.currentWidth(), 2 * this.myLayout.currentHeight());
        this.tempHistory.reset();
        this.showUpdateTemperature();
        do {
            this.tempHistory.addTempPoint(this.getT());
            this.metropolis(this.tempHistory);
            this.showUpdateTemperature();
            this.setT(this.getT() * this.myUI.getOptCoolRate());
        } while (!this.terminate(5));
    }

    public void showSelectMove() throws InterruptedException {
        this.myUI.showSelectMove();
    }

    public void showAcceptMove() throws InterruptedException {
        this.myUI.showAcceptMove();
        this.tempHistory.addSample(this.myLayout.currentCost(), true);
    }

    public void showRejectMove() throws InterruptedException {
        this.myUI.showRejectMove();
        this.tempHistory.addSample(this.myLayout.currentCost(), false);
    }

    public void showCompleteMove() throws InterruptedException {
        this.myUI.showCompleteMove();
    }

    public void showUpdateTemperature() throws InterruptedException {
        this.myUI.showUpdateTemperature();
    }
}

