/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class PTempHistory {
    private double maxTemperature = 0.0;
    private double overallMaxCost = 0.0;
    public double maxAcceptedCost = 0.0;
    private double maxAverageCost = 0.0;
    private double overallMinCost = Double.MAX_VALUE;
    private List historyList = new ArrayList();
    private PTempHistoryPoint currentTempPoint = null;

    public double getOverallMaxTemperature() {
        return this.maxTemperature;
    }

    public double getOverallMaxCost() {
        return this.overallMaxCost;
    }

    public double getMaxAcceptedCost() {
        return this.maxAcceptedCost;
    }

    public double getMaxAverageCost() {
        return this.maxAverageCost;
    }

    public double getOverallMinCost() {
        return this.overallMinCost;
    }

    public void addTempPoint(double d) {
        if (this.currentTempPoint != null) {
            this.maxAverageCost = Math.max(this.maxAverageCost, this.currentTempPoint.getAverageCost());
        }
        this.currentTempPoint = new PTempHistoryPoint(d);
        this.historyList.add(this.currentTempPoint);
        this.maxTemperature = Math.max(this.maxTemperature, d);
    }

    public PTempHistoryPoint getTempPoint(int n) {
        return (PTempHistoryPoint)this.historyList.get(n);
    }

    public PTempHistoryPoint getCurrentTempPoint() {
        return this.currentTempPoint;
    }

    public int numTempPoints() {
        return this.historyList.size();
    }

    public void reset() {
        this.historyList.clear();
        this.maxTemperature = 0.0;
        this.overallMaxCost = 0.0;
        this.maxAcceptedCost = 0.0;
        this.maxAverageCost = 0.0;
        this.overallMinCost = Double.MAX_VALUE;
    }

    public void addSample(double d, boolean bl) {
        this.overallMaxCost = Math.max(this.overallMaxCost, d);
        if (bl) {
            this.maxAcceptedCost = Math.max(this.maxAcceptedCost, d);
        }
        this.overallMinCost = Math.min(this.overallMinCost, d);
        this.currentTempPoint.addSample(d, bl);
    }

    double getCurrentTemp() {
        return this.currentTempPoint.getTemperature();
    }
}

