/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

class PTempHistoryPoint {
    private double temperature = 0.0;
    private double maxCost = 0.0;
    private double minCost = Double.MAX_VALUE;
    private double averageCost = 0.0;
    private double sumCost = 0.0;
    private int attemptCount = 0;
    private int acceptCount = 0;
    private int rejectCount = 0;
    public static List samples = new ArrayList(500);

    public PTempHistoryPoint(double d) {
        this.temperature = d;
        samples.clear();
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getMaxCost() {
        return this.maxCost;
    }

    public double getMinCost() {
        return this.minCost;
    }

    public double getAverageCost() {
        return this.averageCost;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public int getRejectCount() {
        return this.rejectCount;
    }

    public double getAcceptPercent() {
        return (double)this.acceptCount / (double)(this.acceptCount + this.rejectCount) * 100.0;
    }

    public double getStdev() {
        double d = 0.0;
        int n = 0;
        while (n < samples.size()) {
            Double d2 = (Double)samples.get(n);
            double d3 = d2 - this.averageCost;
            d += d3 * d3;
            ++n;
        }
        return Math.sqrt(d / (double)(this.acceptCount - 1));
    }

    void addSample(double d, boolean bl) {
        ++this.attemptCount;
        if (bl) {
            this.minCost = Math.min(this.minCost, d);
            this.maxCost = Math.max(this.maxCost, d);
            this.sumCost += d;
            samples.add(new Double(d));
            ++this.acceptCount;
            this.averageCost = this.sumCost / (double)this.acceptCount;
        } else {
            ++this.rejectCount;
        }
    }
}

