/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class UIAnnealer
extends JPanel
implements Runnable,
ActionListener,
PAnnealInterface {
    private PAnnealer myAnnealer;
    private PLayout myLayout;
    private UILayout myUILayout;
    private static final int STOP = 0;
    private static final int RUN = 1;
    private static final int PAUSE = 2;
    private static final int STEP = 3;
    private int state = 0;
    private boolean animate = true;
    private Thread runner = null;
    private UIOptionsDialog myDialog;
    private double optT0 = 1.0E-4;
    private boolean optT0Adaptive = true;
    private boolean optAnimateMoves = true;
    private int optMovesPerTemp = 0;
    private boolean optMovesPerTempPerModule = false;
    private double optCoolRate = 0.95;
    private int optSpeed = 50;
    private JPanel annealerPanel;
    private JPanel historyPanel;
    private JPanel statusPanel;
    private JPanel controlPanel;
    private JToggleButton stopButton = new JToggleButton(new ImageIcon(this.getClass().getResource("images/stop.gif")), true);
    private JToggleButton runButton = new JToggleButton(new ImageIcon(this.getClass().getResource("images/start.gif")));
    private JToggleButton pauseButton = new JToggleButton(new ImageIcon(this.getClass().getResource("images/pause.gif")));
    private JToggleButton stepButton = new JToggleButton(new ImageIcon(this.getClass().getResource("images/step.gif")));
    private ButtonGroup bg = new ButtonGroup();
    private JButton optionsButton = new JButton("OPTIONS");
    private JLabel tempLabel = new JLabel("T=");
    private JTextField tempField = new JTextField(8);
    private UIValDisplay tempDisplay = new UIValDisplay("Temperature", 0);
    private UIValDisplay attemptsDisplay = new UIValDisplay("Attempts", 0);
    private UIValDisplay acceptedDisplay = new UIValDisplay("Accepted", 0);
    private UIValDisplay percentDisplay = new UIValDisplay("%", 0);
    private static int ANIMATE_DELAY = 4000;

    public void setOptT0Adaptive(boolean bl) {
        this.optT0Adaptive = bl;
    }

    public void setOptInitialTemperature(double d) {
        this.optT0 = d;
    }

    public void setOptAnimateMoves(boolean bl) {
        this.optAnimateMoves = bl;
    }

    public void setOptMovesPerTemp(int n) {
        this.optMovesPerTemp = n;
    }

    public int getOptMovesPerTemp() {
        return this.optMovesPerTemp;
    }

    public void setOptMovesPerTempPerModule(boolean bl) {
        this.optMovesPerTempPerModule = bl;
    }

    public boolean getOptMovesPerTempPerModule() {
        return this.optMovesPerTempPerModule;
    }

    public void setOptCoolRate(double d) {
        this.optCoolRate = d;
    }

    public double getOptCoolRate() {
        return this.optCoolRate;
    }

    public void setOptSpeed(int n) {
        this.optSpeed = n;
    }

    public int getOptSpeed() {
        return this.optSpeed;
    }

    public UIAnnealer(BufferedReader bufferedReader) throws IOException {
        this.myLayout = new PLayout(bufferedReader);
        this.myUILayout = new UILayout(this.myLayout);
        this.myAnnealer = new PAnnealer(this.myLayout, this);
        this.annealerPanel = new JPanel(new BorderLayout());
        this.setLayout(new GridLayout(1, 2));
        this.add(this.myUILayout);
        this.annealerPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.statusPanel = new UIAnnealStatusPanel();
        this.statusPanel.setLayout(new GridLayout(1, 5));
        this.statusPanel.add(this.tempDisplay);
        this.statusPanel.add(this.attemptsDisplay);
        this.statusPanel.add(this.acceptedDisplay);
        this.statusPanel.add(this.percentDisplay);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.bg.add(this.stopButton);
        this.bg.add(this.runButton);
        this.bg.add(this.pauseButton);
        this.bg.add(this.stepButton);
        this.stopButton.setActionCommand("STOP");
        this.runButton.setActionCommand("RUN");
        this.pauseButton.setActionCommand("PAUSE");
        this.stepButton.setActionCommand("STEP");
        this.optionsButton.setActionCommand("OPTIONS");
        this.stopButton.addActionListener(this);
        this.runButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.stepButton.addActionListener(this);
        this.optionsButton.addActionListener(this);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.stopButton);
        jPanel.add(this.runButton);
        jPanel.add(this.pauseButton);
        jPanel.add(this.stepButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.optionsButton);
        jPanel.add(Box.createHorizontalGlue());
        this.annealerPanel.add((Component)this.statusPanel, "North");
        this.annealerPanel.add((Component)jPanel, "South");
        this.historyPanel = new UITempHistory(this.myAnnealer);
        this.historyPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.annealerPanel.add((Component)this.historyPanel, "Center");
        this.add(this.annealerPanel);
        this.myDialog = new UIOptionsDialog(this);
        this.myDialog.pack();
        ((Component)this.myDialog).setVisible(false);
        this.myDialog.repaint();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "STOP") {
            this.runButton.enable();
            this.pauseButton.disable();
            this.stepButton.disable();
            this.state = 0;
            if (this.runner != null) {
                this.runner.interrupt();
                this.runner = null;
            }
        } else if (string == "RUN") {
            this.pauseButton.enable();
            this.stepButton.disable();
            if (this.state == 0) {
                if (this.runner == null) {
                    this.runner = new Thread(this);
                    this.runner.start();
                    this.state = 1;
                } else {
                    System.out.println("trying to start but non-null thread");
                }
            } else if (this.state == 2) {
                this.state = 1;
                this.notifyAll();
            }
        } else if (string == "PAUSE") {
            if (this.state == 0) {
                this.stopButton.setSelected(true);
            } else {
                this.stepButton.enable();
                this.state = 2;
            }
        } else if (string == "STEP") {
            if (this.state == 0) {
                this.stopButton.setSelected(true);
            } else {
                this.state = 3;
                this.notifyAll();
            }
        } else if (string == "OPTIONS") {
            if (!this.myDialog.isVisible()) {
                ((Component)this.myDialog).setVisible(true);
                this.myDialog.toFront();
            } else {
                ((Component)this.myDialog).setVisible(false);
            }
        }
    }

    public void run() {
        try {
            if (this.optT0Adaptive) {
                this.myAnnealer.findT0();
            } else {
                this.myAnnealer.setT0(this.optT0);
            }
            this.myAnnealer.anneal();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.state = 0;
        this.stopButton.setSelected(true);
        this.runner = null;
    }

    public synchronized void stop() {
        this.runButton.enable();
        this.pauseButton.disable();
        this.stepButton.disable();
        this.state = 0;
        if (this.runner != null) {
            this.runner.interrupt();
            this.runner = null;
        }
    }

    public synchronized void animateDelay() throws InterruptedException {
        Thread.sleep(ANIMATE_DELAY / this.optSpeed);
        if (this.state == 3) {
            this.state = 2;
            this.pauseButton.setSelected(true);
        }
        while (this.state == 2) {
            this.wait();
        }
    }

    public void showSelectMove() throws InterruptedException {
        if (this.optAnimateMoves) {
            this.myUILayout.showSelectMove();
            this.animateDelay();
        }
    }

    public void showAcceptMove() throws InterruptedException {
        this.statusPanel.repaint();
        if (this.optAnimateMoves) {
            this.myUILayout.showAcceptMove();
            this.animateDelay();
        }
    }

    public void showRejectMove() throws InterruptedException {
        this.statusPanel.repaint();
        if (this.optAnimateMoves) {
            this.myUILayout.showRejectMove();
            this.animateDelay();
        }
    }

    public void showCompleteMove() throws InterruptedException {
        this.statusPanel.repaint();
        if (this.optAnimateMoves) {
            this.myUILayout.showCompleteMove();
        }
    }

    public void showUpdateTemperature() throws InterruptedException {
        this.myUILayout.showUpdateTemperature();
        this.repaint();
        this.animateDelay();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Floorplanner - Standalone Application");
        jFrame.getContentPane().setLayout(new BorderLayout());
        ((Component)jFrame).setSize(600, 300);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("ntest10.in"));
            UIAnnealer uIAnnealer = new UIAnnealer(bufferedReader);
            jFrame.getContentPane().add((Component)uIAnnealer, "Center");
            ((Component)jFrame).setVisible(true);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not open file " + fileNotFoundException);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace();
        }
    }

    class UIAnnealStatusPanel
    extends JPanel {
        UIAnnealStatusPanel() {
        }

        public void paintComponent(Graphics graphics) {
            PTempHistory pTempHistory;
            PTempHistoryPoint pTempHistoryPoint;
            if (UIAnnealer.this.state == 0) {
                UIAnnealer.this.myUILayout.setMessage("Annealing Stopped");
            }
            if ((pTempHistoryPoint = (pTempHistory = UIAnnealer.this.myAnnealer.getTempHistory()).getCurrentTempPoint()) != null) {
                UIAnnealer.this.tempDisplay.setValue(pTempHistoryPoint.getTemperature());
                UIAnnealer.this.attemptsDisplay.setValue(pTempHistoryPoint.getAttemptCount());
                UIAnnealer.this.acceptedDisplay.setValue(pTempHistoryPoint.getAcceptCount());
                UIAnnealer.this.percentDisplay.setValue(pTempHistoryPoint.getAcceptPercent());
            }
            super.paintComponent(graphics);
        }
    }
}

