/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;

public class UITempHistory
extends JPanel {
    private PAnnealer myAnnealer;
    private static final int LEFT_OFFSET = 25;
    private static final int RIGHT_OFFSET = 15;
    private static final int TOP_OFFSET = 25;
    private static final int BOT_OFFSET = 20;
    private static final double LOG10_SCALE = Math.log(10.0);
    private int xoffset;
    private int yoffset;
    private int curWidth;
    private int curHeight;
    private double logTempLeft;
    private double logTempRight;
    private double logCostTop;
    private double logCostBot;
    private double costScale;
    private double tempScale;
    private FontMetrics myFontMetrics;

    public UITempHistory(PAnnealer pAnnealer) {
        this.myAnnealer = pAnnealer;
    }

    private double log10(double d) {
        return Math.log(d) / LOG10_SCALE;
    }

    private int log10TempToX(double d) {
        return this.xoffset + (int)(this.tempScale * (d - this.logTempLeft));
    }

    private int log10CostToY(double d) {
        return this.yoffset - (int)(this.costScale * (d - this.logCostBot));
    }

    private void drawXLabel(Graphics graphics, int n) {
        String string = "1E" + Integer.toString(n);
        int n2 = this.log10TempToX(n) - this.myFontMetrics.stringWidth(string) / 2;
        int n3 = this.yoffset + this.myFontMetrics.getHeight() - this.myFontMetrics.getDescent();
        graphics.drawString(string, n2, n3);
    }

    private void drawYLabel(Graphics graphics, int n) {
        String string = "1E" + Integer.toString(n);
        int n2 = this.xoffset - this.myFontMetrics.stringWidth(string) - 2;
        int n3 = this.log10CostToY(n);
        graphics.drawString(string, n2, n3);
    }

    private void drawLegend(Graphics graphics) {
        String string = "Cost vs. Temperature";
        graphics.setColor(Color.black);
        int n = this.xoffset + this.curWidth / 2 - this.myFontMetrics.stringWidth(string) / 2;
        int n2 = this.yoffset - this.curHeight - 5;
        graphics.drawString(string, n, n2);
    }

    public void paintComponent(Graphics graphics) {
        PTempHistory pTempHistory = this.myAnnealer.getTempHistory();
        if (pTempHistory.getMaxAverageCost() == 0.0) {
            return;
        }
        if (pTempHistory.getOverallMaxTemperature() == 0.0) {
            return;
        }
        if (pTempHistory.numTempPoints() == 0) {
            return;
        }
        this.myFontMetrics = graphics.getFontMetrics();
        Insets insets = this.getInsets();
        this.curWidth = this.getWidth() - insets.left - insets.right - 25 - 15;
        this.curHeight = this.getHeight() - insets.top - insets.bottom - 25 - 20;
        this.xoffset = insets.left + 25;
        this.yoffset = insets.top + this.curHeight + 25;
        this.logCostTop = Math.ceil(this.log10(pTempHistory.getMaxAcceptedCost()));
        this.logCostBot = Math.floor(this.log10(pTempHistory.getOverallMinCost()));
        this.logTempRight = this.log10(pTempHistory.getOverallMaxTemperature());
        this.logTempLeft = Math.min(this.log10(pTempHistory.getCurrentTemp()), Math.ceil(this.logTempRight) - 3.0);
        this.costScale = (double)this.curHeight / (this.logCostTop - this.logCostBot);
        this.tempScale = (double)this.curWidth / (this.logTempRight - this.logTempLeft);
        PTempHistoryPoint pTempHistoryPoint = null;
        PTempHistoryPoint pTempHistoryPoint2 = null;
        this.drawLegend(graphics);
        graphics.setColor(Color.gray);
        graphics.drawLine(this.xoffset, this.log10CostToY(this.logCostBot), this.xoffset + this.curWidth, this.log10CostToY(this.logCostBot));
        int n = (int)Math.ceil(this.logCostBot);
        while (n <= (int)Math.floor(this.logCostTop)) {
            graphics.drawLine(this.xoffset, this.log10CostToY(n), this.xoffset + this.curWidth, this.log10CostToY(n));
            this.drawYLabel(graphics, n);
            ++n;
        }
        graphics.drawLine(this.xoffset, this.log10CostToY(this.logCostTop), this.xoffset + this.curWidth, this.log10CostToY(this.logCostTop));
        if (Math.ceil(this.logTempLeft) > this.logTempLeft) {
            graphics.drawLine(this.log10TempToX(this.logTempLeft), this.yoffset, this.log10TempToX(this.logTempLeft), insets.top + 25);
        }
        int n2 = (int)Math.ceil(this.logTempLeft);
        while (n2 <= (int)Math.floor(this.logTempRight)) {
            graphics.drawLine(this.log10TempToX(n2), this.yoffset, this.log10TempToX(n2), insets.top + 25);
            this.drawXLabel(graphics, n2);
            ++n2;
        }
        if (Math.floor(this.logTempRight) < this.logTempRight) {
            graphics.drawLine(this.log10TempToX(this.logTempRight), this.yoffset, this.log10TempToX(this.logTempRight), insets.top + 25);
        }
        int n3 = 0;
        while (n3 < pTempHistory.numTempPoints()) {
            pTempHistoryPoint = pTempHistory.getTempPoint(n3);
            if (pTempHistoryPoint2 != null) {
                graphics.setColor(Color.red);
                graphics.drawLine(this.log10TempToX(this.log10(pTempHistoryPoint2.getTemperature())), this.yoffset - (int)((this.log10(pTempHistoryPoint2.getMaxCost()) - this.logCostBot) * this.costScale), this.log10TempToX(this.log10(pTempHistoryPoint.getTemperature())), this.log10CostToY(this.log10(pTempHistoryPoint.getMaxCost())));
                graphics.setColor(Color.green);
                graphics.drawLine(this.log10TempToX(this.log10(pTempHistoryPoint2.getTemperature())), this.yoffset - (int)((this.log10(pTempHistoryPoint2.getMinCost()) - this.logCostBot) * this.costScale), this.log10TempToX(this.log10(pTempHistoryPoint.getTemperature())), this.yoffset - (int)((this.log10(pTempHistoryPoint.getMinCost()) - this.logCostBot) * this.costScale));
                graphics.setColor(Color.black);
                graphics.setColor(Color.black);
                graphics.drawLine(this.log10TempToX(this.log10(pTempHistoryPoint2.getTemperature())), this.yoffset - (int)((this.log10(pTempHistoryPoint2.getAverageCost()) - this.logCostBot) * this.costScale), this.log10TempToX(this.log10(pTempHistoryPoint.getTemperature())), this.yoffset - (int)((this.log10(pTempHistoryPoint.getAverageCost()) - this.logCostBot) * this.costScale));
            }
            pTempHistoryPoint2 = pTempHistoryPoint;
            ++n3;
        }
    }
}

